/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.persistence.EdcPersistenceException;
import org.eclipse.dataspaceconnector.sql.ArgumentHandler;
import org.eclipse.dataspaceconnector.sql.ArgumentHandlers;
import org.eclipse.dataspaceconnector.sql.ResultSetMapper;

public final class SqlQueryExecutor {
    private SqlQueryExecutor() {
    }

    public static int executeQuery(Connection connection, String sql, Object ... arguments) {
        int n;
        block8: {
            Objects.requireNonNull(connection, "connection");
            Objects.requireNonNull(sql, "sql");
            Objects.requireNonNull(arguments, "arguments");
            PreparedStatement statement = connection.prepareStatement(sql, 1);
            try {
                SqlQueryExecutor.setArguments(statement, arguments);
                int n2 = n = statement.execute() ? 0 : statement.getUpdateCount();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new EdcPersistenceException(exception.getMessage(), (Throwable)exception);
                }
            }
            statement.close();
        }
        return n;
    }

    public static <T> List<T> executeQuery(Connection connection, ResultSetMapper<T> resultSetMapper, String sql, Object ... arguments) {
        List list;
        block8: {
            Objects.requireNonNull(connection, "connection");
            Objects.requireNonNull(resultSetMapper, "resultSetMapper");
            Objects.requireNonNull(sql, "sql");
            Objects.requireNonNull(arguments, "arguments");
            PreparedStatement statement = connection.prepareStatement(sql, 1);
            try {
                SqlQueryExecutor.setArguments(statement, arguments);
                List list2 = list = statement.execute() ? SqlQueryExecutor.mapResultSet(statement.getResultSet(), resultSetMapper) : Collections.emptyList();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new EdcPersistenceException(exception.getMessage(), (Throwable)exception);
                }
            }
            statement.close();
        }
        return list;
    }

    private static void setArguments(PreparedStatement statement, Object[] arguments) throws SQLException {
        for (int index = 0; index < arguments.length; ++index) {
            int position = index + 1;
            SqlQueryExecutor.setArgument(statement, position, arguments[index]);
        }
    }

    private static void setArgument(PreparedStatement statement, int position, Object argument) throws SQLException {
        ArgumentHandler argumentHandler = SqlQueryExecutor.findArgumentHandler(argument);
        if (argumentHandler != null) {
            argumentHandler.handle(statement, position, argument);
            return;
        }
        statement.setObject(position, argument);
    }

    private static ArgumentHandler findArgumentHandler(Object argument) {
        for (ArgumentHandlers handler : ArgumentHandlers.values()) {
            if (!handler.accepts(argument)) continue;
            return handler;
        }
        return null;
    }

    private static <T> List<T> mapResultSet(ResultSet resultSet, ResultSetMapper<T> resultSetMapper) throws Exception {
        LinkedList<T> results = new LinkedList<T>();
        if (resultSet != null) {
            while (resultSet.next()) {
                results.add(resultSetMapper.mapResultSet(resultSet));
            }
        }
        return results;
    }
}

