/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.eclipse.dataspaceconnector.sql.datasource.PooledDataSourceConnection;
import org.eclipse.dataspaceconnector.sql.pool.ConnectionPool;

public class ConnectionPoolDataSource
implements DataSource {
    private final ConnectionPool connectionPool;

    public ConnectionPoolDataSource(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new PooledDataSourceConnection(this.connectionPool.getConnection(), this.connectionPool);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

