/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.dataspaceconnector.spi.query.Criterion;
import org.eclipse.dataspaceconnector.spi.result.Result;

public class SqlConditionExpression {
    private static final String IN_OPERATOR = "in";
    private static final String LIKE_OPERATOR = "like";
    private static final String EQUALS_OPERATOR = "=";
    private static final List<String> SUPPORTED_PREPARED_STATEMENT_OPERATORS = List.of("=", "like", "in");
    private static final String PREPARED_STATEMENT_PLACEHOLDER = "?";
    private final Criterion criterion;

    public SqlConditionExpression(Criterion criterion) {
        this.criterion = criterion;
    }

    public Result<Void> isValidExpression() {
        boolean isSupportedOperator = SUPPORTED_PREPARED_STATEMENT_OPERATORS.contains(this.criterion.getOperator().toLowerCase());
        if (!isSupportedOperator) {
            return Result.failure((String)("unsupported operator " + this.criterion.getOperator()));
        }
        if (Objects.equals(IN_OPERATOR, this.criterion.getOperator()) && !(this.criterion.getOperandRight() instanceof Iterable)) {
            return Result.failure((String)String.format("The \"%s\" operator requires the right-hand operand to be of type %s", IN_OPERATOR, Iterable.class));
        }
        return Result.success();
    }

    public String toValuePlaceholder() {
        Object operandRight = this.criterion.getOperandRight();
        if (operandRight instanceof Iterable) {
            long size = StreamSupport.stream(((Iterable)operandRight).spliterator(), false).count();
            return String.format("(%s)", String.join((CharSequence)",", Collections.nCopies((int)size, PREPARED_STATEMENT_PLACEHOLDER)));
        }
        return PREPARED_STATEMENT_PLACEHOLDER;
    }

    public Stream<String> toStatementParameter() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.criterion.getOperandLeft().toString());
        Object operandRight = this.criterion.getOperandRight();
        if (operandRight instanceof Iterable) {
            Iterable iterable = (Iterable)operandRight;
            iterable.forEach(o -> result.add(o.toString()));
        } else {
            result.add(operandRight.toString());
        }
        return result.stream();
    }

    public Criterion getCriterion() {
        return this.criterion;
    }
}

