/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.translation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.dataspaceconnector.spi.query.Criterion;
import org.eclipse.dataspaceconnector.spi.query.QuerySpec;
import org.eclipse.dataspaceconnector.spi.result.Result;
import org.eclipse.dataspaceconnector.sql.translation.SqlConditionExpression;
import org.eclipse.dataspaceconnector.sql.translation.TranslationMapping;

public class SqlQueryStatement {
    private static final String LIMIT = "LIMIT ? ";
    private static final String OFFSET = "OFFSET ?";
    private static final String WHERE_TOKEN = "WHERE";
    private static final String AND_TOKEN = "AND";
    private final String selectStatement;
    private final List<String> whereClauses = new ArrayList<String>();
    private final List<Object> parameters = new ArrayList<Object>();

    public SqlQueryStatement(String selectStatement, QuerySpec query, TranslationMapping rootModel) {
        this(selectStatement);
        this.initialize(query, rootModel);
    }

    public SqlQueryStatement(String selectStatement) {
        this.selectStatement = selectStatement;
    }

    public String getQueryAsString() {
        return this.selectStatement + " " + String.join((CharSequence)" ", this.whereClauses) + " LIMIT ? OFFSET ?;";
    }

    public Object[] getParameters() {
        return this.parameters.toArray(Object[]::new);
    }

    public void addParameter(Object param) {
        this.parameters.add(param);
    }

    private void initialize(QuerySpec query, TranslationMapping rootModel) {
        this.whereClauses.clear();
        this.parameters.clear();
        List expr = query.getFilterExpression();
        expr.forEach(e -> this.parseExpression((Criterion)e, rootModel));
        this.parameters.add(query.getLimit());
        this.parameters.add(query.getOffset());
    }

    private void parseExpression(Criterion criterion, TranslationMapping rootModel) {
        String columnName = rootModel.getStatement(criterion.getOperandLeft().toString());
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Operand \"%s\" cannot be mapped to SQL Schema", criterion.getOperandLeft()));
        }
        Criterion newCriterion = new Criterion((Object)columnName, criterion.getOperator(), criterion.getOperandRight());
        String prefix = this.whereClauses.isEmpty() ? WHERE_TOKEN : AND_TOKEN;
        SqlConditionExpression conditionExpr = new SqlConditionExpression(newCriterion);
        Result<Void> validExpression = conditionExpr.isValidExpression();
        if (validExpression.failed()) {
            throw new IllegalArgumentException("This expression is not valid: " + String.join((CharSequence)", ", validExpression.getFailureMessages()));
        }
        String clause = String.format("%s %s %s %s", prefix, columnName, newCriterion.getOperator(), conditionExpr.toValuePlaceholder());
        this.whereClauses.add(clause);
        List params = conditionExpr.toStatementParameter().skip(1L).collect(Collectors.toList());
        this.parameters.addAll(params);
    }
}

