/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.translation;

import java.util.HashMap;
import java.util.Map;

public abstract class TranslationMapping {
    protected final Map<String, Object> fieldMap = new HashMap<String, Object>();

    public String getStatement(String canonicalPropertyName) {
        String[] leftHandTokens = canonicalPropertyName.split("\\.", 2);
        String key = leftHandTokens[0];
        Object entry = this.fieldMap.get(key);
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Translation failed for Model '%s' at token '%s'", this.getClass().getName(), key));
        }
        if (entry instanceof TranslationMapping) {
            TranslationMapping mappingEntry = (TranslationMapping)entry;
            String nextToken = leftHandTokens.length < 2 ? null : leftHandTokens[1];
            return mappingEntry.getStatement(nextToken);
        }
        return entry.toString();
    }

    protected void add(String fieldId, Object value) {
        this.fieldMap.put(fieldId, value);
    }
}

