/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.common.concurrency;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import org.eclipse.dataspaceconnector.common.concurrency.LockException;

public class LockManager {
    private static final int DEFAULT_TIMEOUT = 1000;
    private final ReadWriteLock lock;
    private final int timeout;

    public LockManager(ReadWriteLock lock) {
        this(lock, 1000);
    }

    public LockManager(ReadWriteLock lock, int timeout) {
        this.lock = lock;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readLock(Supplier<T> work) {
        try {
            if (!this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new LockException("Timeout acquiring read lock");
            }
            try {
                T t = work.get();
                return t;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T writeLock(Supplier<T> work) {
        try {
            if (!this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                throw new LockException("Timeout acquiring write lock");
            }
            try {
                T t = work.get();
                return t;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new LockException(e);
        }
    }
}

