/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.common.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.dataspaceconnector.common.reflection.ReflectionException;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    private static final String ARRAY_INDEXER_REGEX = ".*\\[([0-9])+\\]";
    private static final String OPENING_BRACKET = "[";
    private static final String CLOSING_BRACKET = "]";

    public static <T> T getFieldValue(String propertyName, Object object) {
        Objects.requireNonNull(propertyName, "propertyName");
        Objects.requireNonNull(object, "object");
        if (propertyName.contains(".")) {
            int dotIx = propertyName.indexOf(".");
            String field = propertyName.substring(0, dotIx);
            String rest = propertyName.substring(dotIx + 1);
            if ((object = ReflectionUtil.getFieldValue(field, object)) == null) {
                return null;
            }
            return ReflectionUtil.getFieldValue(rest, object);
        }
        if (propertyName.matches(ARRAY_INDEXER_REGEX)) {
            int openingBracketIx = propertyName.indexOf(OPENING_BRACKET);
            int closingBracketIx = propertyName.indexOf(CLOSING_BRACKET);
            String propName = propertyName.substring(0, openingBracketIx);
            int arrayIndex = Integer.parseInt(propertyName.substring(openingBracketIx + 1, closingBracketIx));
            List iterableObject = (List)ReflectionUtil.getFieldValue(propName, object);
            return (T)iterableObject.get(arrayIndex);
        }
        try {
            if (object instanceof Map) {
                Map map = (Map)object;
                return (T)map.get(propertyName);
            }
            Field field = ReflectionUtil.getFieldRecursive(object.getClass(), propertyName);
            if (field == null) {
                throw new ReflectionException(propertyName);
            }
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T getFieldValueSilent(String propertyName, Object object) {
        try {
            return ReflectionUtil.getFieldValue(propertyName, object);
        }
        catch (ReflectionException ignored) {
            return null;
        }
    }

    @NotNull
    public static <T> Comparator<T> propertyComparator(boolean isAscending, String property) {
        return (def1, def2) -> {
            Object o1 = ReflectionUtil.getFieldValueSilent(property, def1);
            Object o2 = ReflectionUtil.getFieldValueSilent(property, def2);
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (!(o1 instanceof Comparable)) {
                throw new IllegalArgumentException("A property '" + property + "' is not comparable!");
            }
            Comparable comp1 = (Comparable)o1;
            Comparable comp2 = (Comparable)o2;
            return isAscending ? comp1.compareTo(comp2) : comp2.compareTo(comp1);
        };
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        return ReflectionUtil.getAllFieldsRecursive(clazz).stream().filter(f -> f.getName().equals(fieldName)).findFirst().orElse(null);
    }

    public static List<Field> getAllFieldsRecursive(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(ReflectionUtil.getAllFieldsRecursive(clazz.getSuperclass()));
        List filteredFields = Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList());
        result.addAll(filteredFields);
        return result;
    }
}

