/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.common.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PartitionIterator<T>
implements Iterator<List<T>> {
    private final Iterator<T> source;
    private final int partitionSize;

    public static <T> Stream<List<T>> streamOf(Stream<T> source, int partitionSize) {
        PartitionIterator iterator = new PartitionIterator(source.iterator(), partitionSize);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public PartitionIterator(Iterator<T> source, int partitionSize) {
        this.source = Objects.requireNonNull(source);
        if (partitionSize <= 0) {
            throw new IllegalArgumentException("Invalid partition size:" + partitionSize);
        }
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public List<T> next() {
        ArrayList<T> partition = new ArrayList<T>(this.partitionSize);
        while (this.source.hasNext() && partition.size() < this.partitionSize) {
            partition.add(this.source.next());
        }
        return partition;
    }
}

