/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.contract.offer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.dataspaceconnector.spi.iam.ClaimToken;
import org.eclipse.dataspaceconnector.spi.query.Criterion;

public class ContractOfferQuery {
    private ClaimToken claimToken;
    private List<Criterion> criteria;
    private long offset;
    private long limit;

    private ContractOfferQuery() {
    }

    public static Builder builder() {
        return Builder.newInstance();
    }

    public ClaimToken getClaimToken() {
        return this.claimToken;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public static final class Builder {
        private final List<Criterion> criteria = new ArrayList<Criterion>();
        private ClaimToken claimToken;
        private long offset;
        private long limit;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder claimToken(ClaimToken claimToken) {
            this.claimToken = claimToken;
            return this;
        }

        public Builder criterion(Criterion criterion) {
            this.criteria.add(criterion);
            return this;
        }

        public Builder criteria(Collection<Criterion> criteria) {
            this.criteria.addAll(criteria);
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public ContractOfferQuery build() {
            ContractOfferQuery contractOfferQuery = new ContractOfferQuery();
            contractOfferQuery.claimToken = this.claimToken;
            contractOfferQuery.offset = this.offset;
            contractOfferQuery.limit = this.limit;
            contractOfferQuery.criteria = this.criteria;
            return contractOfferQuery;
        }
    }
}

