/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.agreement;

import java.util.Objects;
import org.eclipse.dataspaceconnector.policy.model.Policy;
import org.eclipse.dataspaceconnector.spi.types.domain.contract.agreement.ContractAgreement;
import org.eclipse.dataspaceconnector.spi.types.domain.message.RemoteMessage;

public class ContractAgreementRequest
implements RemoteMessage {
    private String protocol;
    private String connectorId;
    private String connectorAddress;
    private String correlationId;
    private ContractAgreement contractAgreement;
    private Policy policy;

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public ContractAgreement getContractAgreement() {
        return this.contractAgreement;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public static class Builder {
        private final ContractAgreementRequest contractAgreementRequest = new ContractAgreementRequest();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder protocol(String protocol) {
            this.contractAgreementRequest.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.contractAgreementRequest.connectorId = connectorId;
            return this;
        }

        public Builder connectorAddress(String connectorAddress) {
            this.contractAgreementRequest.connectorAddress = connectorAddress;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.contractAgreementRequest.correlationId = correlationId;
            return this;
        }

        public Builder contractAgreement(ContractAgreement contractAgreement) {
            this.contractAgreementRequest.contractAgreement = contractAgreement;
            return this;
        }

        public Builder policy(Policy policy) {
            this.contractAgreementRequest.policy = policy;
            return this;
        }

        public ContractAgreementRequest build() {
            Objects.requireNonNull(this.contractAgreementRequest.protocol, "protocol");
            Objects.requireNonNull(this.contractAgreementRequest.connectorId, "connectorId");
            Objects.requireNonNull(this.contractAgreementRequest.connectorAddress, "connectorAddress");
            Objects.requireNonNull(this.contractAgreementRequest.contractAgreement, "contractAgreement");
            Objects.requireNonNull(this.contractAgreementRequest.policy, "policy");
            Objects.requireNonNull(this.contractAgreementRequest.correlationId, "correlationId");
            return this.contractAgreementRequest;
        }
    }
}

