/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.negotiation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.entity.StatefulEntity;
import org.eclipse.dataspaceconnector.spi.types.domain.contract.agreement.ContractAgreement;
import org.eclipse.dataspaceconnector.spi.types.domain.contract.negotiation.ContractNegotiationStates;
import org.eclipse.dataspaceconnector.spi.types.domain.contract.offer.ContractOffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="dataspaceconnector:contractnegotiation")
@JsonDeserialize(builder=Builder.class)
public class ContractNegotiation
extends StatefulEntity<ContractNegotiation> {
    private String correlationId;
    private String counterPartyId;
    private String counterPartyAddress;
    private String protocol;
    private Type type = Type.CONSUMER;
    private ContractAgreement contractAgreement;
    private List<ContractOffer> contractOffers = new ArrayList<ContractOffer>();

    public Type getType() {
        return this.type;
    }

    public String getCounterPartyId() {
        return this.counterPartyId;
    }

    public String getCounterPartyAddress() {
        return this.counterPartyAddress;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    @NotNull
    public String getProtocol() {
        return this.protocol;
    }

    public List<ContractOffer> getContractOffers() {
        return this.contractOffers;
    }

    public void addContractOffer(ContractOffer offer) {
        this.contractOffers.add(offer);
    }

    public ContractOffer getLastContractOffer() {
        int size = this.contractOffers.size();
        if (size == 0) {
            return null;
        }
        return this.contractOffers.get(size - 1);
    }

    public ContractAgreement getContractAgreement() {
        return this.contractAgreement;
    }

    public void setContractAgreement(ContractAgreement agreement) {
        this.contractAgreement = agreement;
    }

    public void transitionInitial() {
        this.transition(ContractNegotiationStates.INITIAL, ContractNegotiationStates.REQUESTING, ContractNegotiationStates.UNSAVED);
    }

    public void transitionRequesting() {
        if (Type.PROVIDER == this.type) {
            throw new IllegalStateException("Provider processes have no REQUESTING state");
        }
        this.transition(ContractNegotiationStates.REQUESTING, ContractNegotiationStates.REQUESTING, ContractNegotiationStates.INITIAL);
    }

    public void transitionRequested() {
        if (Type.PROVIDER == this.type) {
            this.transition(ContractNegotiationStates.REQUESTED, ContractNegotiationStates.UNSAVED);
        } else {
            this.transition(ContractNegotiationStates.REQUESTED, ContractNegotiationStates.REQUESTED, ContractNegotiationStates.REQUESTING);
        }
    }

    public void transitionOffering() {
        if (Type.CONSUMER == this.type) {
            this.transition(ContractNegotiationStates.CONSUMER_OFFERING, ContractNegotiationStates.CONSUMER_OFFERING, ContractNegotiationStates.REQUESTED);
        } else {
            this.transition(ContractNegotiationStates.PROVIDER_OFFERING, ContractNegotiationStates.PROVIDER_OFFERING, ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.REQUESTED);
        }
    }

    public void transitionOffered() {
        if (Type.CONSUMER == this.type) {
            this.transition(ContractNegotiationStates.CONSUMER_OFFERED, ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.CONSUMER_OFFERING);
        } else {
            this.transition(ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.PROVIDER_OFFERING);
        }
    }

    public void transitionApproving() {
        if (Type.PROVIDER == this.type) {
            throw new IllegalStateException("Provider processes have no CONSUMER_APPROVING state");
        }
        this.transition(ContractNegotiationStates.CONSUMER_APPROVING, ContractNegotiationStates.CONSUMER_APPROVING, ContractNegotiationStates.CONSUMER_OFFERED, ContractNegotiationStates.REQUESTED);
    }

    public void transitionApproved() {
        if (Type.PROVIDER == this.type) {
            throw new IllegalStateException("Provider processes have no CONSUMER_APPROVED state");
        }
        this.transition(ContractNegotiationStates.CONSUMER_APPROVED, ContractNegotiationStates.CONSUMER_APPROVED, ContractNegotiationStates.CONSUMER_APPROVING, ContractNegotiationStates.PROVIDER_OFFERED);
    }

    public void transitionDeclining() {
        if (Type.CONSUMER == this.type) {
            this.transition(ContractNegotiationStates.DECLINING, ContractNegotiationStates.DECLINING, ContractNegotiationStates.REQUESTED, ContractNegotiationStates.CONSUMER_OFFERED, ContractNegotiationStates.CONSUMER_APPROVED);
        } else {
            this.transition(ContractNegotiationStates.DECLINING, ContractNegotiationStates.DECLINING, ContractNegotiationStates.REQUESTED, ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.CONSUMER_APPROVED);
        }
    }

    public void transitionDeclined() {
        if (Type.CONSUMER == this.type) {
            this.transition(ContractNegotiationStates.DECLINED, ContractNegotiationStates.DECLINING, ContractNegotiationStates.CONSUMER_OFFERED, ContractNegotiationStates.REQUESTED);
        } else {
            this.transition(ContractNegotiationStates.DECLINED, ContractNegotiationStates.DECLINING, ContractNegotiationStates.PROVIDER_OFFERED, ContractNegotiationStates.CONFIRMING, ContractNegotiationStates.CONFIRMED, ContractNegotiationStates.REQUESTED);
        }
    }

    public void transitionConfirming() {
        if (Type.CONSUMER == this.type) {
            throw new IllegalStateException("Consumer processes have no CONFIRMING state");
        }
        this.transition(ContractNegotiationStates.CONFIRMING, ContractNegotiationStates.CONFIRMING, ContractNegotiationStates.REQUESTED, ContractNegotiationStates.PROVIDER_OFFERED);
    }

    public void transitionConfirmed() {
        if (Type.CONSUMER == this.type) {
            this.transition(ContractNegotiationStates.CONFIRMED, ContractNegotiationStates.CONFIRMING, ContractNegotiationStates.CONSUMER_APPROVED, ContractNegotiationStates.REQUESTED, ContractNegotiationStates.CONSUMER_OFFERED, ContractNegotiationStates.CONFIRMED);
        } else {
            this.transition(ContractNegotiationStates.CONFIRMED, ContractNegotiationStates.CONFIRMING);
        }
    }

    public void transitionError(@Nullable String errorDetail) {
        this.state = ContractNegotiationStates.ERROR.code();
        this.errorDetail = errorDetail;
        this.stateCount = 1;
        this.updateStateTimestamp();
    }

    public ContractNegotiation copy() {
        Builder builder = Builder.newInstance().correlationId(this.correlationId).counterPartyId(this.counterPartyId).counterPartyAddress(this.counterPartyAddress).protocol(this.protocol).type(this.type).contractAgreement(this.contractAgreement).contractOffers(this.contractOffers);
        return (ContractNegotiation)this.copy(builder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ContractNegotiation that = (ContractNegotiation)((Object)o);
        return this.state == that.state && this.stateCount == that.stateCount && this.stateTimestamp == that.stateTimestamp && Objects.equals(this.id, that.id) && Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.counterPartyId, that.counterPartyId) && Objects.equals(this.clock, that.clock) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.traceContext, that.traceContext) && this.type == that.type && Objects.equals(this.contractAgreement, that.contractAgreement) && Objects.equals(this.contractOffers, that.contractOffers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.correlationId, this.counterPartyId, this.clock, this.protocol, this.traceContext, this.type, this.state, this.stateCount, this.stateTimestamp, this.contractAgreement, this.contractOffers});
    }

    private void transition(ContractNegotiationStates end, ContractNegotiationStates ... starts) {
        if (Arrays.stream(starts).noneMatch(s -> s.code() == this.state)) {
            throw new IllegalStateException(String.format("Cannot transition from state %s to %s", new Object[]{ContractNegotiationStates.from(this.state), ContractNegotiationStates.from(end.code())}));
        }
        this.transitionTo(end.code());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends StatefulEntity.Builder<ContractNegotiation, Builder> {
        private Builder(ContractNegotiation negotiation) {
            super((StatefulEntity)negotiation);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder(new ContractNegotiation());
        }

        public Builder protocol(String protocol) {
            ((ContractNegotiation)this.entity).protocol = protocol;
            return this;
        }

        public Builder counterPartyId(String id) {
            ((ContractNegotiation)this.entity).counterPartyId = id;
            return this;
        }

        public Builder counterPartyAddress(String address) {
            ((ContractNegotiation)this.entity).counterPartyAddress = address;
            return this;
        }

        public Builder correlationId(String id) {
            ((ContractNegotiation)this.entity).correlationId = id;
            return this;
        }

        public Builder contractAgreement(ContractAgreement agreement) {
            ((ContractNegotiation)this.entity).contractAgreement = agreement;
            return this;
        }

        public Builder contractOffers(List<ContractOffer> contractOffers) {
            ((ContractNegotiation)this.entity).contractOffers = contractOffers;
            return this;
        }

        public Builder contractOffer(ContractOffer contractOffer) {
            ((ContractNegotiation)this.entity).contractOffers.add(contractOffer);
            return this;
        }

        public Builder type(Type type) {
            ((ContractNegotiation)this.entity).type = type;
            return this;
        }

        public Builder self() {
            return this;
        }

        public ContractNegotiation build() {
            Objects.requireNonNull(((ContractNegotiation)this.entity).counterPartyId);
            Objects.requireNonNull(((ContractNegotiation)this.entity).counterPartyAddress);
            Objects.requireNonNull(((ContractNegotiation)this.entity).protocol);
            if (Type.PROVIDER == ((ContractNegotiation)this.entity).type) {
                Objects.requireNonNull(((ContractNegotiation)this.entity).correlationId);
            }
            return (ContractNegotiation)super.build();
        }
    }

    public static enum Type {
        CONSUMER,
        PROVIDER;

    }
}

