/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.negotiation;

import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.types.domain.contract.offer.ContractOffer;
import org.eclipse.dataspaceconnector.spi.types.domain.message.RemoteMessage;

public class ContractOfferRequest
implements RemoteMessage {
    private Type type = Type.COUNTER_OFFER;
    private String protocol;
    private String connectorId;
    private String connectorAddress;
    private String correlationId;
    private ContractOffer contractOffer;

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Type getType() {
        return this.type;
    }

    public ContractOffer getContractOffer() {
        return this.contractOffer;
    }

    public static enum Type {
        INITIAL,
        COUNTER_OFFER;

    }

    public static class Builder {
        private final ContractOfferRequest contractOfferRequest = new ContractOfferRequest();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder protocol(String protocol) {
            this.contractOfferRequest.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.contractOfferRequest.connectorId = connectorId;
            return this;
        }

        public Builder connectorAddress(String connectorAddress) {
            this.contractOfferRequest.connectorAddress = connectorAddress;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.contractOfferRequest.correlationId = correlationId;
            return this;
        }

        public Builder contractOffer(ContractOffer contractOffer) {
            this.contractOfferRequest.contractOffer = contractOffer;
            return this;
        }

        public Builder type(Type type) {
            this.contractOfferRequest.type = type;
            return this;
        }

        public ContractOfferRequest build() {
            Objects.requireNonNull(this.contractOfferRequest.protocol, "protocol");
            Objects.requireNonNull(this.contractOfferRequest.connectorId, "connectorId");
            Objects.requireNonNull(this.contractOfferRequest.connectorAddress, "connectorAddress");
            Objects.requireNonNull(this.contractOfferRequest.contractOffer, "contractOffer");
            return this.contractOfferRequest;
        }
    }
}

