/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.negotiation;

import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.types.domain.message.RemoteMessage;

public class ContractRejection
implements RemoteMessage {
    private String protocol;
    private String connectorId;
    private String connectorAddress;
    private String correlationId;
    private String rejectionReason;

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public static class Builder {
        private final ContractRejection contractRejection = new ContractRejection();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder protocol(String protocol) {
            this.contractRejection.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.contractRejection.connectorId = connectorId;
            return this;
        }

        public Builder connectorAddress(String connectorAddress) {
            this.contractRejection.connectorAddress = connectorAddress;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.contractRejection.correlationId = correlationId;
            return this;
        }

        public Builder rejectionReason(String rejectionReason) {
            this.contractRejection.rejectionReason = rejectionReason;
            return this;
        }

        public ContractRejection build() {
            Objects.requireNonNull(this.contractRejection.protocol, "protocol");
            Objects.requireNonNull(this.contractRejection.connectorId, "connectorId");
            Objects.requireNonNull(this.contractRejection.connectorAddress, "connectorAddress");
            Objects.requireNonNull(this.contractRejection.correlationId, "correlationId");
            Objects.requireNonNull(this.contractRejection.rejectionReason, "rejectionReason");
            return this.contractRejection;
        }
    }
}

