/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.offer;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.asset.AssetSelectorExpression;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(builder=Builder.class)
public class ContractDefinition {
    private String id;
    private String accessPolicyId;
    private String contractPolicyId;
    private AssetSelectorExpression selectorExpression;

    private ContractDefinition() {
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getAccessPolicyId() {
        return this.accessPolicyId;
    }

    @NotNull
    public String getContractPolicyId() {
        return this.contractPolicyId;
    }

    @NotNull
    public AssetSelectorExpression getSelectorExpression() {
        return this.selectorExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractDefinition that = (ContractDefinition)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.accessPolicyId, that.accessPolicyId) && Objects.equals(this.contractPolicyId, that.contractPolicyId) && Objects.equals(this.selectorExpression, that.selectorExpression);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accessPolicyId, this.contractPolicyId, this.selectorExpression);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final ContractDefinition definition = new ContractDefinition();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.definition.id = id;
            return this;
        }

        public Builder accessPolicyId(String policyId) {
            this.definition.accessPolicyId = policyId;
            return this;
        }

        public Builder contractPolicyId(String policyId) {
            this.definition.contractPolicyId = policyId;
            return this;
        }

        public Builder selectorExpression(AssetSelectorExpression expression) {
            this.definition.selectorExpression = expression;
            return this;
        }

        public ContractDefinition build() {
            Objects.requireNonNull(this.definition.id);
            Objects.requireNonNull(this.definition.accessPolicyId);
            Objects.requireNonNull(this.definition.contractPolicyId);
            Objects.requireNonNull(this.definition.selectorExpression);
            return this.definition;
        }
    }
}

