/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.contract.offer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.eclipse.dataspaceconnector.policy.model.Policy;
import org.eclipse.dataspaceconnector.spi.types.domain.asset.Asset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(builder=Builder.class)
public class ContractOffer {
    private String id;
    private Policy policy;
    private Asset asset;
    private String assetId;
    private URI provider;
    private URI consumer;
    private ZonedDateTime offerStart;
    private ZonedDateTime offerEnd;
    private ZonedDateTime contractStart;
    private ZonedDateTime contractEnd;

    @Nullable
    public String getAssetId() {
        return this.assetId;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public URI getProvider() {
        return this.provider;
    }

    @Nullable
    public URI getConsumer() {
        return this.consumer;
    }

    @Nullable
    public ZonedDateTime getOfferStart() {
        return this.offerStart;
    }

    @Nullable
    public ZonedDateTime getOfferEnd() {
        return this.offerEnd;
    }

    @Nullable
    public ZonedDateTime getContractStart() {
        return this.contractStart;
    }

    @Nullable
    public ZonedDateTime getContractEnd() {
        return this.contractEnd;
    }

    @NotNull
    public Asset getAsset() {
        return this.asset;
    }

    @Nullable
    public Policy getPolicy() {
        return this.policy;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.policy, this.asset, this.provider, this.consumer, this.offerStart, this.offerEnd, this.contractStart, this.contractEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractOffer that = (ContractOffer)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.policy, that.policy) && Objects.equals(this.asset, that.asset) && Objects.equals(this.provider, that.provider) && Objects.equals(this.consumer, that.consumer) && Objects.equals(this.offerStart, that.offerStart) && Objects.equals(this.offerEnd, that.offerEnd) && Objects.equals(this.contractStart, that.contractStart) && Objects.equals(this.contractEnd, that.contractEnd);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private Asset asset;
        private Policy policy;
        private String id;
        private URI provider;
        private URI consumer;
        private ZonedDateTime offerStart;
        private ZonedDateTime offerEnd;
        private ZonedDateTime contractStart;
        private ZonedDateTime contractEnd;
        private String assetId;

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder provider(URI provider) {
            this.provider = provider;
            return this;
        }

        public Builder consumer(URI consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder offerStart(ZonedDateTime date) {
            this.offerStart = date;
            return this;
        }

        public Builder offerEnd(ZonedDateTime date) {
            this.offerEnd = date;
            return this;
        }

        public Builder contractStart(ZonedDateTime date) {
            this.contractStart = date;
            return this;
        }

        public Builder contractEnd(ZonedDateTime date) {
            this.contractEnd = date;
            return this;
        }

        public Builder policy(Policy policy) {
            this.policy = policy;
            return this;
        }

        public Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public ContractOffer build() {
            Objects.requireNonNull(this.id);
            if (this.assetId != null && this.asset != null) {
                throw new IllegalArgumentException("Asset and AssetId are mutually exclusive");
            }
            if (this.policy == null) {
                throw new IllegalArgumentException("Policy must not be null!");
            }
            ContractOffer offer = new ContractOffer();
            offer.id = this.id;
            offer.policy = this.policy;
            offer.asset = this.asset;
            offer.provider = this.provider;
            offer.consumer = this.consumer;
            offer.offerStart = this.offerStart;
            offer.offerEnd = this.offerEnd;
            offer.contractStart = this.contractStart;
            offer.contractEnd = this.contractEnd;
            offer.assetId = this.assetId;
            return offer;
        }
    }
}

