/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.dataloading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.dataspaceconnector.dataloading.DataSink;
import org.eclipse.dataspaceconnector.dataloading.ValidationException;
import org.eclipse.dataspaceconnector.spi.result.AbstractResult;
import org.eclipse.dataspaceconnector.spi.result.Result;

public class DataLoader<T> {
    private Collection<Function<T, Result<T>>> validationPredicates = new ArrayList<Function<T, Result<T>>>();
    private DataSink<T> sink;

    protected DataLoader() {
    }

    public void insert(T item) {
        List failedValidations = this.validate(item).filter(AbstractResult::failed).collect(Collectors.toUnmodifiableList());
        if (!failedValidations.isEmpty()) {
            String message = failedValidations.stream().map(AbstractResult::getFailureMessages).flatMap(Collection::stream).collect(Collectors.joining("; "));
            throw new ValidationException(message);
        }
        this.sink.accept(item);
    }

    public void insertAll(Collection<T> items) {
        Stream allValidationResults = items.stream().flatMap(this::validate);
        List errorMessages = allValidationResults.filter(AbstractResult::failed).map(AbstractResult::getFailureMessages).flatMap(Collection::stream).collect(Collectors.toList());
        if (!errorMessages.isEmpty()) {
            throw new ValidationException(String.join((CharSequence)"; ", errorMessages));
        }
        items.forEach(this.sink::accept);
    }

    private Stream<Result<T>> validate(T item) {
        return this.validationPredicates.stream().map(vr -> (Result)vr.apply(item));
    }

    public static final class Builder<T> {
        private final DataLoader<T> loader = new DataLoader();

        private Builder() {
        }

        public static <T> Builder<T> newInstance() {
            return new Builder<T>();
        }

        public Builder<T> sink(DataSink<T> sink) {
            this.loader.sink = sink;
            return this;
        }

        public Builder<T> andPredicate(Function<T, Result<T>> predicate) {
            this.loader.validationPredicates.add(predicate);
            return this;
        }

        public Builder<T> predicates(Collection<Function<T, Result<T>>> predicates) {
            this.loader.validationPredicates = predicates;
            return this;
        }

        public DataLoader<T> build() {
            return this.loader;
        }
    }
}

