/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.transfer.provision;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ResourceDefinition;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ResourceManifest;

public class ResourceManifestContext {
    private Map<Class, List<ResourceDefinition>> resourceDefinitions = new HashMap<Class, List<ResourceDefinition>>();

    public ResourceManifestContext(ResourceManifest resourceManifest) {
        resourceManifest.getDefinitions().forEach(this::addDefinition);
    }

    public <T extends ResourceDefinition> void addDefinition(T definition) {
        this.resourceDefinitions.computeIfAbsent(definition.getClass(), c -> new ArrayList()).add(definition);
    }

    public <T extends ResourceDefinition> void replaceDefinitions(Class<T> type, List<T> definitions) {
        this.resourceDefinitions.put(type, definitions);
    }

    public <T extends ResourceDefinition> List<T> getDefinitions(Class<T> type) {
        return this.resourceDefinitions.get(type);
    }

    public List<ResourceDefinition> getDefinitions() {
        ArrayList<ResourceDefinition> list = new ArrayList<ResourceDefinition>();
        this.resourceDefinitions.values().forEach(list::addAll);
        return list;
    }
}

