/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dataspaceconnector.spi.types.domain.DataAddress;
import org.eclipse.dataspaceconnector.spi.types.domain.Polymorphic;
import org.eclipse.dataspaceconnector.spi.types.domain.message.RemoteMessage;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.TransferType;

@JsonTypeName(value="dataspaceconnector:datarequest")
@JsonDeserialize(builder=Builder.class)
public class DataRequest
implements RemoteMessage,
Polymorphic {
    private String id;
    private String processId;
    private String connectorAddress;
    private String protocol;
    private String connectorId;
    private String assetId;
    private String contractId;
    private DataAddress dataDestination;
    private boolean managedResources = true;
    private Map<String, String> properties = new HashMap<String, String>();
    private TransferType transferType = new TransferType();

    private DataRequest() {
    }

    public String getId() {
        return this.id;
    }

    public String getProcessId() {
        return this.processId;
    }

    void associateWithProcessId(String processId) {
        this.processId = processId;
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getContractId() {
        return this.contractId;
    }

    public String getDestinationType() {
        return this.dataDestination != null ? this.dataDestination.getType() : null;
    }

    public DataAddress getDataDestination() {
        return this.dataDestination;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isManagedResources() {
        return this.managedResources;
    }

    public DataRequest copy(String newId) {
        return Builder.newInstance().id(newId).processId(this.processId).connectorAddress(this.connectorAddress).protocol(this.protocol).connectorId(this.connectorId).assetId(this.assetId).contractId(this.contractId).dataAddress(this.dataDestination).transferType(this.transferType).managedResources(this.managedResources).properties(this.properties).build();
    }

    public void updateDestination(DataAddress dataAddress) {
        this.dataDestination = dataAddress;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final DataRequest request = new DataRequest();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.request.id = id;
            return this;
        }

        public Builder processId(String id) {
            this.request.processId = id;
            return this;
        }

        public Builder connectorAddress(String address) {
            this.request.connectorAddress = address;
            return this;
        }

        public Builder protocol(String protocol) {
            this.request.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.request.connectorId = connectorId;
            return this;
        }

        public Builder contractId(String contractId) {
            this.request.contractId = contractId;
            return this;
        }

        public Builder assetId(String assetId) {
            this.request.assetId = assetId;
            return this;
        }

        public Builder destinationType(String type) {
            if (this.request.dataDestination == null) {
                this.request.dataDestination = DataAddress.Builder.newInstance().type(type).build();
            } else {
                this.request.dataDestination.setType(type);
            }
            return this;
        }

        public Builder dataDestination(DataAddress destination) {
            this.request.dataDestination = destination;
            return this;
        }

        public Builder managedResources(boolean value) {
            this.request.managedResources = value;
            return this;
        }

        public Builder properties(Map<String, String> value) {
            this.request.properties = value;
            return this;
        }

        public DataRequest build() {
            if (this.request.dataDestination == null && this.request.getDestinationType() == null) {
                throw new IllegalArgumentException("A data destination or type must be specified");
            }
            return this.request;
        }

        public Builder transferType(TransferType transferType) {
            this.request.transferType = transferType;
            return this;
        }

        private Builder dataAddress(DataAddress dataAddress) {
            this.request.dataDestination = dataAddress;
            return this;
        }
    }
}

