/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonTypeName(value="dataspaceconnector:deprovisionedresource")
@JsonDeserialize(builder=Builder.class)
public class DeprovisionedResource {
    private String provisionedResourceId;
    private boolean inProcess;
    private boolean error;
    private String errorMessage;

    private DeprovisionedResource() {
    }

    public String getProvisionedResourceId() {
        return this.provisionedResourceId;
    }

    @JsonProperty(value="error")
    public boolean isError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isInProcess() {
        return this.inProcess;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final DeprovisionedResource resource = new DeprovisionedResource();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder provisionedResourceId(String id) {
            this.resource.provisionedResourceId = id;
            return this;
        }

        public Builder errorMessage(String message) {
            this.resource.errorMessage = message;
            this.resource.error = true;
            return this;
        }

        @JsonProperty(value="inProcess")
        public Builder inProcess(boolean value) {
            this.resource.inProcess = value;
            return this;
        }

        @JsonProperty(value="error")
        Builder error(boolean value) {
            this.resource.error = value;
            return this;
        }

        public DeprovisionedResource build() {
            Objects.requireNonNull(this.resource.provisionedResourceId, "provisionedResourceId");
            return this.resource;
        }
    }
}

