/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ProvisionedResource;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.SecretToken;
import org.jetbrains.annotations.Nullable;

public class ProvisionResponse {
    private final ProvisionedResource resource;
    private final SecretToken secretToken;
    private final boolean inProcess;

    private ProvisionResponse(ProvisionedResource resource, @Nullable SecretToken secretToken) {
        this.resource = resource;
        this.secretToken = secretToken;
        this.inProcess = false;
    }

    public ProvisionResponse() {
        this.resource = null;
        this.secretToken = null;
        this.inProcess = true;
    }

    public boolean isInProcess() {
        return this.inProcess;
    }

    public ProvisionedResource getResource() {
        return this.resource;
    }

    @Nullable
    public SecretToken getSecretToken() {
        return this.secretToken;
    }

    public static class Builder {
        private ProvisionedResource resource;
        private SecretToken secretToken;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder resource(ProvisionedResource resource) {
            this.resource = resource;
            return this;
        }

        public Builder secretToken(SecretToken secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        public ProvisionResponse build() {
            Objects.requireNonNull(this.resource, "resource");
            return new ProvisionResponse(this.resource, this.secretToken);
        }
    }
}

