/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ProvisionedResource;

@JsonTypeName(value="dataspaceconnector:provisionedresourceset")
@JsonDeserialize(builder=Builder.class)
public class ProvisionedResourceSet {
    private String transferProcessId;
    private final List<ProvisionedResource> resources = new ArrayList<ProvisionedResource>();

    public String getTransferProcessId() {
        return this.transferProcessId;
    }

    void setTransferProcessId(String transferProcessId) {
        this.transferProcessId = transferProcessId;
        this.resources.forEach(r -> r.setTransferProcessId(transferProcessId));
    }

    public List<ProvisionedResource> getResources() {
        return this.resources;
    }

    public void addResource(ProvisionedResource resource) {
        if (this.transferProcessId != null) {
            resource.setTransferProcessId(this.transferProcessId);
        }
        this.resources.add(resource);
    }

    public boolean empty() {
        return this.resources.isEmpty();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final ProvisionedResourceSet resourceSet = new ProvisionedResourceSet();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder resources(List<ProvisionedResource> resources) {
            this.resourceSet.resources.addAll(resources);
            return this;
        }

        public Builder transferProcessId(String id) {
            this.resourceSet.setTransferProcessId(id);
            return this;
        }

        public ProvisionedResourceSet build() {
            return this.resourceSet;
        }
    }
}

