/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ResourceDefinition;
import org.jetbrains.annotations.NotNull;

@JsonTypeName(value="dataspaceconnector:resourcemanifest")
@JsonDeserialize(builder=Builder.class)
public class ResourceManifest {
    private String transferProcessId;
    private final List<ResourceDefinition> definitions = new ArrayList<ResourceDefinition>();

    private ResourceManifest() {
    }

    @NotNull
    public List<ResourceDefinition> getDefinitions() {
        return this.definitions;
    }

    public void addDefinition(ResourceDefinition definition) {
        if (this.transferProcessId != null) {
            definition.setTransferProcessId(this.transferProcessId);
        }
        this.definitions.add(definition);
    }

    public boolean empty() {
        return this.definitions.isEmpty();
    }

    void setTransferProcessId(String transferProcessId) {
        Objects.requireNonNull(transferProcessId, "transferProcessId");
        this.transferProcessId = transferProcessId;
        this.definitions.forEach(d -> d.setTransferProcessId(transferProcessId));
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final ResourceManifest manifest = new ResourceManifest();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder definitions(List<ResourceDefinition> definitions) {
            this.manifest.definitions.addAll(definitions);
            return this;
        }

        public ResourceManifest build() {
            return this.manifest;
        }
    }
}

