/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.dataspaceconnector.spi.entity.StatefulEntity;
import org.eclipse.dataspaceconnector.spi.types.domain.DataAddress;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.DataRequest;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.DeprovisionedResource;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ProvisionedResource;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ProvisionedResourceSet;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ResourceDefinition;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.ResourceManifest;
import org.eclipse.dataspaceconnector.spi.types.domain.transfer.TransferProcessStates;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeName(value="dataspaceconnector:transferprocess")
@JsonDeserialize(builder=Builder.class)
public class TransferProcess
extends StatefulEntity<TransferProcess> {
    private Type type = Type.CONSUMER;
    private DataRequest dataRequest;
    private DataAddress contentDataAddress;
    private ResourceManifest resourceManifest;
    private ProvisionedResourceSet provisionedResourceSet;
    private List<DeprovisionedResource> deprovisionedResources = new ArrayList<DeprovisionedResource>();

    private TransferProcess() {
    }

    public List<DeprovisionedResource> getDeprovisionedResources() {
        return this.deprovisionedResources;
    }

    public Type getType() {
        return this.type;
    }

    public DataRequest getDataRequest() {
        return this.dataRequest;
    }

    public ResourceManifest getResourceManifest() {
        return this.resourceManifest;
    }

    public ProvisionedResourceSet getProvisionedResourceSet() {
        return this.provisionedResourceSet;
    }

    public DataAddress getContentDataAddress() {
        return this.contentDataAddress;
    }

    public void transitionInitial() {
        this.transition(TransferProcessStates.INITIAL, TransferProcessStates.UNSAVED);
    }

    public void transitionProvisioning(ResourceManifest manifest) {
        this.transition(TransferProcessStates.PROVISIONING, TransferProcessStates.INITIAL, TransferProcessStates.PROVISIONING);
        this.resourceManifest = manifest;
        this.resourceManifest.setTransferProcessId(this.id);
    }

    public void addProvisionedResource(ProvisionedResource resource) {
        if (this.provisionedResourceSet == null) {
            this.provisionedResourceSet = ProvisionedResourceSet.Builder.newInstance().transferProcessId(this.id).build();
        }
        this.provisionedResourceSet.addResource(resource);
    }

    public void addContentDataAddress(DataAddress dataAddress) {
        this.contentDataAddress = dataAddress;
    }

    public void addDeprovisionedResource(DeprovisionedResource resource) {
        this.deprovisionedResources.add(resource);
    }

    @Nullable
    public ProvisionedResource getProvisionedResource(String id) {
        if (this.provisionedResourceSet == null) {
            return null;
        }
        return this.provisionedResourceSet.getResources().stream().filter(r -> r.getId().equals(id)).findFirst().orElse(null);
    }

    @JsonIgnore
    @NotNull
    public List<ResourceDefinition> getResourcesToProvision() {
        if (this.resourceManifest == null) {
            return Collections.emptyList();
        }
        if (this.provisionedResourceSet == null) {
            return Collections.unmodifiableList(this.resourceManifest.getDefinitions());
        }
        Set provisionedResources = this.provisionedResourceSet.getResources().stream().map(ProvisionedResource::getResourceDefinitionId).collect(Collectors.toSet());
        return this.resourceManifest.getDefinitions().stream().filter(r -> !provisionedResources.contains(r.getId())).collect(Collectors.toList());
    }

    public boolean provisioningComplete() {
        if (this.resourceManifest == null) {
            return false;
        }
        return this.getResourcesToProvision().isEmpty();
    }

    @JsonIgnore
    @NotNull
    public List<ProvisionedResource> getResourcesToDeprovision() {
        if (this.provisionedResourceSet == null) {
            return Collections.emptyList();
        }
        Set deprovisionedResources = this.deprovisionedResources.stream().map(DeprovisionedResource::getProvisionedResourceId).collect(Collectors.toSet());
        return this.provisionedResourceSet.getResources().stream().filter(r -> !deprovisionedResources.contains(r.getId())).collect(Collectors.toList());
    }

    public boolean deprovisionComplete() {
        return this.getResourcesToDeprovision().isEmpty();
    }

    public void transitionProvisioned() {
        this.transition(TransferProcessStates.PROVISIONED, TransferProcessStates.PROVISIONING, TransferProcessStates.PROVISIONED, TransferProcessStates.REQUESTED);
    }

    public void transitionRequesting() {
        if (Type.PROVIDER == this.type) {
            throw new IllegalStateException("Provider processes have no REQUESTING state");
        }
        this.transition(TransferProcessStates.REQUESTING, TransferProcessStates.PROVISIONED, TransferProcessStates.REQUESTING);
    }

    public void transitionRequested() {
        if (Type.PROVIDER == this.type) {
            throw new IllegalStateException("Provider processes have no REQUESTED state");
        }
        this.transition(TransferProcessStates.REQUESTED, TransferProcessStates.PROVISIONED, TransferProcessStates.REQUESTING, TransferProcessStates.REQUESTED);
    }

    public void transitionInProgressOrStreaming() {
        DataRequest dataRequest = this.getDataRequest();
        if (dataRequest.getTransferType().isFinite()) {
            this.transitionInProgress();
        } else {
            this.transitionStreaming();
        }
    }

    public void transitionInProgress() {
        if (this.type == Type.CONSUMER) {
            this.transition(TransferProcessStates.IN_PROGRESS, TransferProcessStates.REQUESTED, TransferProcessStates.IN_PROGRESS);
        } else {
            this.transition(TransferProcessStates.IN_PROGRESS, TransferProcessStates.REQUESTED, TransferProcessStates.PROVISIONED, TransferProcessStates.IN_PROGRESS);
        }
    }

    public void transitionStreaming() {
        if (this.type == Type.CONSUMER) {
            this.transition(TransferProcessStates.STREAMING, TransferProcessStates.REQUESTED, TransferProcessStates.STREAMING);
        } else {
            this.transition(TransferProcessStates.STREAMING, TransferProcessStates.PROVISIONED, TransferProcessStates.STREAMING);
        }
    }

    public void transitionCompleted() {
        this.transition(TransferProcessStates.COMPLETED, TransferProcessStates.COMPLETED, TransferProcessStates.IN_PROGRESS, TransferProcessStates.REQUESTED, TransferProcessStates.STREAMING);
    }

    public void transitionDeprovisioning() {
        this.transition(TransferProcessStates.DEPROVISIONING, TransferProcessStates.COMPLETED, TransferProcessStates.DEPROVISIONING);
    }

    public void transitionDeprovisioned() {
        this.transition(TransferProcessStates.DEPROVISIONED, TransferProcessStates.DEPROVISIONING, TransferProcessStates.DEPROVISIONED);
    }

    public void transitionCancelled() {
        TransferProcessStates[] allowedStates = new TransferProcessStates[]{TransferProcessStates.UNSAVED, TransferProcessStates.INITIAL, TransferProcessStates.PROVISIONING, TransferProcessStates.PROVISIONED, TransferProcessStates.REQUESTED, TransferProcessStates.REQUESTING, TransferProcessStates.IN_PROGRESS, TransferProcessStates.STREAMING, TransferProcessStates.DEPROVISIONED, TransferProcessStates.DEPROVISIONING, TransferProcessStates.CANCELLED};
        this.transition(TransferProcessStates.CANCELLED, allowedStates);
    }

    public void transitionEnded() {
        this.transition(TransferProcessStates.ENDED, TransferProcessStates.DEPROVISIONED);
    }

    public void transitionError(@Nullable String errorDetail) {
        this.errorDetail = errorDetail;
        this.state = TransferProcessStates.ERROR.code();
        this.stateCount = 1;
        this.updateStateTimestamp();
    }

    public TransferProcess copy() {
        Builder builder = Builder.newInstance().resourceManifest(this.resourceManifest).dataRequest(this.dataRequest).provisionedResourceSet(this.provisionedResourceSet).contentDataAddress(this.contentDataAddress).deprovisionedResources(this.deprovisionedResources).type(this.type);
        return (TransferProcess)this.copy(builder);
    }

    public Builder toBuilder() {
        return new Builder(this.copy());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TransferProcess that = (TransferProcess)((Object)o);
        return this.id.equals(that.id);
    }

    public String toString() {
        return "TransferProcess{id='" + this.id + "', state=" + TransferProcessStates.from(this.state) + ", stateTimestamp=" + Instant.ofEpochMilli(this.stateTimestamp) + "}";
    }

    private void transition(TransferProcessStates end, TransferProcessStates ... starts) {
        if (end.code() < this.state) {
            return;
        }
        if (Arrays.stream(starts).noneMatch(s -> s.code() == this.state)) {
            throw new IllegalStateException(String.format("Cannot transition from state %s to %s", new Object[]{TransferProcessStates.from(this.state), TransferProcessStates.from(end.code())}));
        }
        this.transitionTo(end.code());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends StatefulEntity.Builder<TransferProcess, Builder> {
        private Builder(TransferProcess process) {
            super((StatefulEntity)process);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder(new TransferProcess());
        }

        public Builder type(Type type) {
            ((TransferProcess)this.entity).type = type;
            return this;
        }

        public Builder dataRequest(DataRequest request) {
            ((TransferProcess)this.entity).dataRequest = request;
            return this;
        }

        public Builder resourceManifest(ResourceManifest manifest) {
            ((TransferProcess)this.entity).resourceManifest = manifest;
            return this;
        }

        public Builder contentDataAddress(DataAddress dataAddress) {
            ((TransferProcess)this.entity).contentDataAddress = dataAddress;
            return this;
        }

        public Builder provisionedResourceSet(ProvisionedResourceSet set) {
            ((TransferProcess)this.entity).provisionedResourceSet = set;
            return this;
        }

        public Builder deprovisionedResources(List<DeprovisionedResource> resources) {
            ((TransferProcess)this.entity).deprovisionedResources = resources;
            return this;
        }

        public Builder self() {
            return this;
        }

        public TransferProcess build() {
            if (((TransferProcess)this.entity).resourceManifest != null) {
                ((TransferProcess)this.entity).resourceManifest.setTransferProcessId(((TransferProcess)this.entity).id);
            }
            if (((TransferProcess)this.entity).provisionedResourceSet != null) {
                ((TransferProcess)this.entity).provisionedResourceSet.setTransferProcessId(((TransferProcess)this.entity).id);
            }
            if (((TransferProcess)this.entity).dataRequest != null) {
                ((TransferProcess)this.entity).dataRequest.associateWithProcessId(((TransferProcess)this.entity).id);
            }
            return (TransferProcess)super.build();
        }
    }

    public static enum Type {
        CONSUMER,
        PROVIDER;

    }
}

