/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import java.util.Arrays;

public enum TransferProcessStates {
    UNSAVED(0),
    INITIAL(100),
    PROVISIONING(200),
    PROVISIONED(300),
    REQUESTING(400),
    REQUESTED(500),
    IN_PROGRESS(600),
    STREAMING(700),
    COMPLETED(800),
    DEPROVISIONING(900),
    DEPROVISIONED(1000),
    ENDED(1100),
    CANCELLED(1200),
    ERROR(-1);

    private final int code;

    private TransferProcessStates(int code) {
        this.code = code;
    }

    public static TransferProcessStates from(int code) {
        return Arrays.stream(TransferProcessStates.values()).filter(tps -> tps.code == code).findFirst().orElse(null);
    }

    public int code() {
        return this.code;
    }
}

