/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.spi.types.domain.transfer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class TransferType {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private String contentType = "application/octet-stream";
    private boolean isFinite = true;

    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="isFinite")
    public boolean isFinite() {
        return this.isFinite;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String contentType = "application/octet-stream";
        private boolean isFinite = true;

        private Builder() {
        }

        @JsonCreator
        public static Builder transferType() {
            return new Builder();
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder isFinite(boolean isFinite) {
            this.isFinite = isFinite;
            return this;
        }

        public TransferType build() {
            TransferType transferType = new TransferType();
            transferType.contentType = Objects.requireNonNull(this.contentType, "Content type cannot be null!");
            transferType.isFinite = this.isFinite;
            return transferType;
        }
    }
}

