/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.eclipse.digitaltwin.aas4j.v3.dataformat.core.internal.deserialization.EnumDeserializer;
import org.eclipse.digitaltwin.aas4j.v3.dataformat.core.internal.serialization.EnumSerializer;
import org.eclipse.digitaltwin.aas4j.v3.dataformat.core.internal.util.ReflectionHelper;
import org.eclipse.digitaltwin.aas4j.v3.dataformat.json.internal.ReflectionAnnotationIntrospector;
import org.eclipse.digitaltwin.basyx.core.StandardizedLiteralEnum;
import org.eclipse.digitaltwin.basyx.http.SerializationExtension;
import org.eclipse.digitaltwin.basyx.http.StandardizedLiteralEnumDeserializer;
import org.eclipse.digitaltwin.basyx.http.StandardizedLiteralEnumSerializer;
import org.eclipse.digitaltwin.basyx.http.description.Profile;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Component;

@Component
public class Aas4JHTTPSerializationExtension
implements SerializationExtension {
    protected SimpleAbstractTypeResolver typeResolver;

    public Aas4JHTTPSerializationExtension() {
        this.initTypeResolver();
    }

    @Override
    public void extend(Jackson2ObjectMapperBuilder builder) {
        builder.featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).serializationInclusion(JsonInclude.Include.NON_NULL).featuresToDisable(new Object[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).annotationIntrospector((AnnotationIntrospector)new ReflectionAnnotationIntrospector()).modulesToInstall(new Module[]{this.buildEnumModule(), this.buildImplementationModule()});
        ReflectionHelper.JSON_MIXINS.entrySet().forEach(x -> builder.mixIn((Class)x.getKey(), (Class)x.getValue()));
    }

    private void initTypeResolver() {
        this.typeResolver = new SimpleAbstractTypeResolver();
        ReflectionHelper.DEFAULT_IMPLEMENTATIONS.stream().forEach(x -> this.typeResolver.addMapping(x.getInterfaceType(), x.getImplementationType()));
    }

    protected SimpleModule buildEnumModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(StandardizedLiteralEnum.class, new StandardizedLiteralEnumSerializer());
        module.addDeserializer(Profile.class, new StandardizedLiteralEnumDeserializer<Profile>(Profile.class));
        ReflectionHelper.ENUMS.forEach(x -> module.addSerializer(x, (JsonSerializer)new EnumSerializer()));
        ReflectionHelper.ENUMS.forEach(x -> module.addDeserializer(x, (JsonDeserializer)new EnumDeserializer(x)));
        return module;
    }

    protected SimpleModule buildImplementationModule() {
        SimpleModule module = new SimpleModule();
        module.setAbstractTypes(this.typeResolver);
        return module;
    }
}

