/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.List;
import org.apache.commons.lang3.SerializationException;
import org.eclipse.digitaltwin.aas4j.v3.dataformat.core.DeserializationException;
import org.eclipse.digitaltwin.basyx.core.MessageType;
import org.eclipse.digitaltwin.basyx.core.ResultMessage;
import org.eclipse.digitaltwin.basyx.core.exceptions.AssetLinkDoesNotExistException;
import org.eclipse.digitaltwin.basyx.core.exceptions.CollidingAssetLinkException;
import org.eclipse.digitaltwin.basyx.core.exceptions.CollidingIdentifierException;
import org.eclipse.digitaltwin.basyx.core.exceptions.ElementDoesNotExistException;
import org.eclipse.digitaltwin.basyx.core.exceptions.ElementNotAFileException;
import org.eclipse.digitaltwin.basyx.core.exceptions.FeatureNotSupportedException;
import org.eclipse.digitaltwin.basyx.core.exceptions.FileDoesNotExistException;
import org.eclipse.digitaltwin.basyx.core.exceptions.IdentificationMismatchException;
import org.eclipse.digitaltwin.basyx.core.exceptions.InsufficientPermissionException;
import org.eclipse.digitaltwin.basyx.core.exceptions.InvalidTargetInformationException;
import org.eclipse.digitaltwin.basyx.core.exceptions.MissingAuthorizationConfigurationException;
import org.eclipse.digitaltwin.basyx.core.exceptions.MissingIdentifierException;
import org.eclipse.digitaltwin.basyx.core.exceptions.MissingKeyTypeException;
import org.eclipse.digitaltwin.basyx.core.exceptions.NotInvokableException;
import org.eclipse.digitaltwin.basyx.core.exceptions.NullSubjectException;
import org.eclipse.digitaltwin.basyx.core.exceptions.OperationDelegationException;
import org.eclipse.digitaltwin.basyx.core.exceptions.RepositoryRegistryLinkException;
import org.eclipse.digitaltwin.basyx.core.exceptions.RepositoryRegistryUnlinkException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class BaSyxExceptionHandler {
    private ResponseEntity<Object> buildResponse(String message, HttpStatus status, Object object) {
        Object body = new ResultMessage(message, status.value(), object.getClass().getSimpleName() + "-" + status.value(), MessageType.Error).build();
        return new ResponseEntity(List.of(body), (HttpStatusCode)status);
    }

    @ExceptionHandler(value={ElementDoesNotExistException.class})
    public ResponseEntity<Object> handleElementNotFoundException(ElementDoesNotExistException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.NOT_FOUND, exception);
    }

    @ExceptionHandler(value={AssetLinkDoesNotExistException.class})
    public ResponseEntity<Object> handleElementNotFoundException(AssetLinkDoesNotExistException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.NOT_FOUND, exception);
    }

    @ExceptionHandler(value={FileDoesNotExistException.class})
    public ResponseEntity<Object> handleElementNotFoundException(FileDoesNotExistException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.NOT_FOUND, exception);
    }

    @ExceptionHandler(value={CollidingIdentifierException.class})
    public ResponseEntity<Object> handleCollidingIdentifierException(CollidingIdentifierException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.CONFLICT, exception);
    }

    @ExceptionHandler(value={MissingIdentifierException.class})
    public ResponseEntity<Object> handleMissingIdentifierException(MissingIdentifierException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={CollidingAssetLinkException.class})
    public ResponseEntity<Object> handleCollidingIdentifierException(CollidingAssetLinkException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.CONFLICT, exception);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Object> handleIllegalArgumentException(IllegalArgumentException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={IdentificationMismatchException.class})
    public ResponseEntity<Object> handleIdMismatchException(IdentificationMismatchException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={FeatureNotSupportedException.class})
    public ResponseEntity<Object> handleFeatureNotSupportedException(FeatureNotSupportedException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.NOT_IMPLEMENTED, exception);
    }

    @ExceptionHandler(value={NotInvokableException.class})
    public ResponseEntity<Object> handleNotInvokableException(NotInvokableException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.METHOD_NOT_ALLOWED, exception);
    }

    @ExceptionHandler(value={ElementNotAFileException.class})
    public ResponseEntity<Object> handleElementNotAFileException(ElementNotAFileException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.PRECONDITION_FAILED, exception);
    }

    @ExceptionHandler(value={InsufficientPermissionException.class})
    public ResponseEntity<Object> handleInsufficientPermissionException(InsufficientPermissionException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.FORBIDDEN, exception);
    }

    @ExceptionHandler(value={NullSubjectException.class})
    public ResponseEntity<Object> handleNullSubjectException(NullSubjectException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.UNAUTHORIZED, exception);
    }

    @ExceptionHandler(value={OperationDelegationException.class})
    public ResponseEntity<Object> handleNullSubjectException(OperationDelegationException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.FAILED_DEPENDENCY, exception);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<Object> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={RepositoryRegistryLinkException.class})
    public ResponseEntity<Object> handleRepositoryRegistryLinkException(RepositoryRegistryLinkException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={RepositoryRegistryUnlinkException.class})
    public ResponseEntity<Object> handleRepositoryRegistryUnlinkException(RepositoryRegistryUnlinkException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={MissingKeyTypeException.class})
    public ResponseEntity<Object> handleMissingKeyTypeException(MissingKeyTypeException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={MissingAuthorizationConfigurationException.class})
    public ResponseEntity<Object> handleMissingAuthorizationConfigurationException(MissingAuthorizationConfigurationException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={InvalidTargetInformationException.class})
    public ResponseEntity<Object> handleInvalidTargetInformationException(InvalidTargetInformationException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={SerializationException.class})
    public ResponseEntity<Object> handleSerializationException(SerializationException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, exception);
    }

    @ExceptionHandler(value={DeserializationException.class})
    public ResponseEntity<Object> handleDeserializationException(DeserializationException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity<Object> handleInvalidFormatException(InvalidFormatException exception) {
        return this.buildResponse(exception.getMessage(), HttpStatus.BAD_REQUEST, exception);
    }
}

