/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import org.eclipse.digitaltwin.basyx.http.CorsPathPatternProvider;
import org.eclipse.digitaltwin.basyx.http.SerializationExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class BaSyxHTTPConfiguration {
    Logger logger = LoggerFactory.getLogger(BaSyxHTTPConfiguration.class);

    @Bean
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder(List<SerializationExtension> serializationExtensions) {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder().serializationInclusion(JsonInclude.Include.NON_NULL);
        for (SerializationExtension serializationExtension : serializationExtensions) {
            serializationExtension.extend(builder);
        }
        return builder;
    }

    @Bean
    public WebMvcConfigurer corsConfigurer(final List<CorsPathPatternProvider> configurationUrlProviders, final @Value(value="${basyx.cors.allowed-origins:}") String[] allowedOrigins, final @Value(value="${basyx.cors.allowed-methods:}") String[] allowedMethods) {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                if (allowedOrigins.length == 0 && allowedMethods.length == 0) {
                    return;
                }
                BaSyxHTTPConfiguration.this.logger.info("---- Configuring CORS ----");
                for (CorsPathPatternProvider provider : configurationUrlProviders) {
                    this.configureOrigins(allowedOrigins, allowedMethods, registry, provider.getPathPattern());
                }
            }

            private void configureOrigins(String[] allowedOrigins2, String[] allowedMethods2, CorsRegistry registry, String pathPattern) {
                BaSyxHTTPConfiguration.this.logger.info(pathPattern + " configured with allowedOriginPatterns " + Arrays.toString(allowedOrigins2));
                BaSyxHTTPConfiguration.this.logger.info((String)(allowedMethods2.length == 0 ? "No allowed methods configured" : pathPattern + " configured with allowedMethods " + Arrays.toString(allowedMethods2)));
                registry.addMapping(pathPattern).allowedOriginPatterns(allowedOrigins2).allowedMethods(allowedMethods2);
            }
        };
    }
}

