/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.eclipse.digitaltwin.basyx.http.Base64UrlEncodedIdentifier;
import org.eclipse.digitaltwin.basyx.http.Base64UrlEncodedIdentifierSize;
import org.springframework.stereotype.Component;

@Component
public class Base64UrlEncodedIdentifierSizeValidator
implements ConstraintValidator<Base64UrlEncodedIdentifierSize, Base64UrlEncodedIdentifier> {
    private int min;
    private int max;

    public void initialize(Base64UrlEncodedIdentifierSize constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
    }

    public boolean isValid(Base64UrlEncodedIdentifier value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int size = this.determineSize(value);
        return size >= this.min && size <= this.max;
    }

    private int determineSize(Base64UrlEncodedIdentifier value) {
        return value.getIdentifier().length();
    }
}

