/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTypeCloneFactory<I, O> {
    private Logger logger = LoggerFactory.getLogger(CustomTypeCloneFactory.class);
    private ObjectMapper mapper;
    private Class<O> elementType;

    public CustomTypeCloneFactory(Class<O> outputElementType, ObjectMapper mapper) {
        this.elementType = outputElementType;
        this.mapper = mapper;
    }

    public List<O> create(List<I> input) {
        String serializedLangString = "";
        try {
            serializedLangString = this.mapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            return (List)this.mapper.readValue(serializedLangString, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, this.elementType));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.logger.error("Failure occurred while creating the clone");
            return null;
        }
    }

    public O create(I input) {
        String serializedLangString = "";
        try {
            serializedLangString = this.mapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            return (O)this.mapper.readValue(serializedLangString, this.elementType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.logger.error("Failure occurred while creating the clone");
            return null;
        }
    }
}

