/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http.description;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.digitaltwin.basyx.http.description.Profile;

@Schema(name="ServiceDescription", description="The Description object enables servers to present their capabilities to the clients, in particular which profiles they implement. At least one defined profile is required. Additional, proprietary attributes might be included. Nevertheless, the server must not expect that a regular client understands them.")
public class ServiceDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private List<Profile> profiles;

    public ServiceDescription profiles(List<Profile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public ServiceDescription addProfilesItem(Profile profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @Size(min=1)
    @Schema(name="profiles", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="profiles")
    public @Size(min=1) List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDescription serviceDescription = (ServiceDescription)o;
        return Objects.equals(this.profiles, serviceDescription.profiles);
    }

    public int hashCode() {
        return Objects.hash(this.profiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceDescription {\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

