/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.digitaltwin.basyx.http.documentation;

import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class RepositoryApiDocumentationConfiguration {
    private static final String TITLE = "BaSyx Repository";
    private static final String DESCRIPTION = "BaSyx Components API";
    protected static final String VERSION = "2.0";
    private static final String LICENSE = "MIT Licence";
    private static final String LICENSE_URL = "https://opensource.org/licenses/mit-license.php";
    private static final String CONTACT_URL = "https://www.eclipse.org/basyx/";
    private static final String CONTACT_EMAIL = "basyx-dev@eclipse.org";
    private static final String CONTACT_NAME = "The BaSyx Developers";

    @Bean
    public OpenAPI customOpenAPI() {
        return new OpenAPI().info(this.apiInfo());
    }

    @Bean
    public ModelResolver modelResolver(Jackson2ObjectMapperBuilder builder) {
        return new ModelResolver(builder.build());
    }

    protected Info apiInfo() {
        return new Info().title(TITLE).description(DESCRIPTION).version(VERSION).contact(this.apiContact()).license(this.apiLicence());
    }

    protected License apiLicence() {
        return new License().name(LICENSE).url(LICENSE_URL);
    }

    protected Contact apiContact() {
        return new Contact().name(CONTACT_NAME).email(CONTACT_EMAIL).url(CONTACT_URL);
    }
}

