/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.http;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.eclipse.dirigible.commons.api.context.ThreadContextFacade;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.commons.api.scripting.IScriptingFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionFacade
implements IScriptingFacade {
    private static final String NO_VALID_REQUEST = "Trying to use HTTP Session Facade without a valid Session (HTTP Request/Response)";
    private static final String INVOCATION_COUNT = "invocation.count";
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionFacade.class);

    static final HttpSession getSession() {
        if (!ThreadContextFacade.isValid()) {
            return null;
        }
        try {
            HttpServletRequest request = (HttpServletRequest)ThreadContextFacade.get((String)HttpServletRequest.class.getCanonicalName());
            if (request != null) {
                int n;
                HttpSession httpSession = request.getSession(true);
                Integer count = (Integer)httpSession.getAttribute(INVOCATION_COUNT);
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                count = n;
                httpSession.setAttribute(INVOCATION_COUNT, (Object)count);
                return httpSession;
            }
        }
        catch (ContextException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static final boolean isValid() {
        HttpSession session = HttpSessionFacade.getSession();
        return session != null;
    }

    public static final String getAttribute(String arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        return session.getAttribute(arg0) != null ? session.getAttribute(arg0).toString() : null;
    }

    public static final String[] getAttributeNames() {
        HttpSession session = HttpSessionFacade.getSession();
        return Collections.list(session.getAttributeNames()).toArray(new String[0]);
    }

    public static final String getAttributeNamesJson() {
        HttpSession session = HttpSessionFacade.getSession();
        String[] array = Collections.list(session.getAttributeNames()).toArray(new String[0]);
        return GsonHelper.GSON.toJson((Object)array);
    }

    public static final long getCreationTime() {
        HttpSession session = HttpSessionFacade.getSession();
        return session.getCreationTime();
    }

    public static final String getId() {
        HttpSession session = HttpSessionFacade.getSession();
        return session.getId();
    }

    public static final long getLastAccessedTime() {
        HttpSession session = HttpSessionFacade.getSession();
        return session.getLastAccessedTime();
    }

    public static final int getMaxInactiveInterval() {
        HttpSession session = HttpSessionFacade.getSession();
        return session.getMaxInactiveInterval();
    }

    public static final void invalidate() {
        HttpSession session = HttpSessionFacade.getSession();
        session.invalidate();
    }

    public static final boolean isNew() {
        HttpSession session = HttpSessionFacade.getSession();
        return session.isNew();
    }

    public static final void setAttribute(String arg0, String arg1) {
        HttpSession session = HttpSessionFacade.getSession();
        session.setAttribute(arg0, (Object)arg1);
    }

    public static final void removeAttribute(String arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        session.removeAttribute(arg0);
    }

    public static final void setMaxInactiveInterval(int arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        session.setMaxInactiveInterval(arg0);
    }

    public static final void setMaxInactiveInterval(Double arg0) {
        HttpSessionFacade.setMaxInactiveInterval(arg0.intValue());
    }
}

