/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.http.client;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyUtils {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final Logger logger = LoggerFactory.getLogger(HttpClientProxyUtils.class);

    public HttpClientProxyUtils() {
        try {
            HttpClientProxyUtils.setProxySettings();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setProxySettings() throws IOException {
        HttpClientProxyUtils.setTrustAllSSL();
    }

    public static CloseableHttpClient getHttpClient(boolean trustAll) {
        CloseableHttpClient httpClient = null;
        if (trustAll) {
            try {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (hostName, sslSession) -> true);
                HttpClientBuilder httpClientBuilder = HttpClients.custom();
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
                HttpClientProxyUtils.setProxyIfNeeded(httpClientBuilder);
                httpClient = httpClientBuilder.build();
            }
            catch (Exception e) {
                logger.error("Error occurred when trying to create a TRUST ALL HTTP Client", (Throwable)e);
                httpClient = HttpClients.createDefault();
            }
        } else {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            HttpClientProxyUtils.setProxyIfNeeded(httpClientBuilder);
            httpClient = httpClientBuilder.build();
        }
        return httpClient;
    }

    private static void setProxyIfNeeded(HttpClientBuilder httpClientBuilder) {
        String httpProxyHost = Configuration.get((String)HTTP_PROXY_HOST);
        String httpProxyPort = Configuration.get((String)HTTP_PROXY_PORT);
        if (!StringUtils.isEmpty((CharSequence)httpProxyHost) && !StringUtils.isEmpty((CharSequence)httpProxyPort)) {
            HttpHost httpProxy = new HttpHost(httpProxyHost, Integer.parseInt(httpProxyPort));
            httpClientBuilder.setProxy(httpProxy);
            HttpClientProxyUtils.setNonProxyHostsIfNeeded(httpClientBuilder, httpProxy);
        }
    }

    private static void setNonProxyHostsIfNeeded(HttpClientBuilder httpClientBuilder, HttpHost httpProxy) {
        String httpNonProxyHosts = Configuration.get((String)HTTP_NON_PROXY_HOSTS);
        if (!StringUtils.isEmpty((CharSequence)httpNonProxyHosts)) {
            final String[] nonProxyHosts = httpNonProxyHosts.split("\\|");
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(httpProxy){

                public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                    String hostname = target.getHostName();
                    for (String nonProxyHost : nonProxyHosts) {
                        if (!this.isNonProxyHost(hostname, nonProxyHost)) continue;
                        return new HttpRoute(target);
                    }
                    return super.determineRoute(target, request, context);
                }

                private boolean isNonProxyHost(String hostname, String nonProxyHost) {
                    return nonProxyHost.startsWith("*.") && hostname.endsWith(nonProxyHost.substring(nonProxyHost.indexOf("*.") + 2)) || nonProxyHost.equalsIgnoreCase(hostname);
                }
            });
        }
    }

    private static void setTrustAllSSL() throws IOException {
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(HttpClientProxyUtils.createTrustAllSSLContext().getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static SSLContext createTrustAllSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext;
    }
}

