/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-FileCopyrightText: 2022 SAP SE or an SAP affiliate company and Eclipse Dirigible contributors
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.dirigible.api.v3.http.access;

import javax.servlet.http.HttpServletRequest;

/**
 * The Interface IAccessManager.
 */
public interface IAccessManager {

	/**
	 * Checks if is in role.
	 *
	 * @param request the request
	 * @param role the role
	 * @return true, if is in role
	 */
	public boolean isInRole(HttpServletRequest request, String role);
}
