/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.http;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.eclipse.dirigible.commons.api.context.ThreadContextFacade;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.commons.api.scripting.IScriptingFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionFacade
implements IScriptingFacade {
    private static final String NO_VALID_REQUEST = "Trying to use HTTP Session Facade without a valid Session (HTTP Request/Response)";
    private static final String INVOCATION_COUNT = "invocation.count";
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionFacade.class);

    static final HttpSession getSession() {
        block6: {
            if (!ThreadContextFacade.isValid()) {
                return null;
            }
            try {
                HttpServletRequest request = (HttpServletRequest)ThreadContextFacade.get((String)HttpServletRequest.class.getCanonicalName());
                if (request != null) {
                    int n;
                    HttpSession httpSession = request.getSession(true);
                    Integer count = (Integer)httpSession.getAttribute(INVOCATION_COUNT);
                    if (count == null) {
                        n = 1;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    count = n;
                    httpSession.setAttribute(INVOCATION_COUNT, (Object)count);
                    return httpSession;
                }
            }
            catch (ContextException e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static final boolean isValid() {
        HttpSession session = HttpSessionFacade.getSession();
        return session != null;
    }

    public static final String getAttribute(String arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.getAttribute(arg0) != null ? session.getAttribute(arg0).toString() : null;
        }
        return null;
    }

    public static final String[] getAttributeNames() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return Collections.list(session.getAttributeNames()).toArray(new String[0]);
        }
        return null;
    }

    public static final String getAttributeNamesJson() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            String[] array = Collections.list(session.getAttributeNames()).toArray(new String[0]);
            return GsonHelper.toJson((Object)array);
        }
        return null;
    }

    public static final long getCreationTime() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.getCreationTime();
        }
        return 0L;
    }

    public static final String getId() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.getId();
        }
        return null;
    }

    public static final long getLastAccessedTime() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.getLastAccessedTime();
        }
        return 0L;
    }

    public static final int getMaxInactiveInterval() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.getMaxInactiveInterval();
        }
        return 0;
    }

    public static final void invalidate() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            session.invalidate();
        }
    }

    public static final boolean isNew() {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            return session.isNew();
        }
        return false;
    }

    public static final void setAttribute(String arg0, String arg1) {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            session.setAttribute(arg0, (Object)arg1);
        }
    }

    public static final void removeAttribute(String arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            session.removeAttribute(arg0);
        }
    }

    public static final void setMaxInactiveInterval(int arg0) {
        HttpSession session = HttpSessionFacade.getSession();
        if (session != null) {
            session.setMaxInactiveInterval(arg0);
        }
    }

    public static final void setMaxInactiveInterval(Double arg0) {
        HttpSessionFacade.setMaxInactiveInterval(arg0.intValue());
    }
}

