/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.dirigible.api.v3.http.client.HttpClientHeader;
import org.eclipse.dirigible.api.v3.http.client.HttpClientParam;
import org.eclipse.dirigible.api.v3.http.client.HttpClientProxyUtils;
import org.eclipse.dirigible.api.v3.http.client.HttpClientRequestOptions;
import org.eclipse.dirigible.api.v3.http.client.HttpClientResponse;
import org.eclipse.dirigible.commons.api.helpers.GsonHelper;
import org.eclipse.dirigible.commons.api.scripting.IScriptingFacade;

public class HttpClientFacade
implements IScriptingFacade {
    private static final HashSet<String> recognizedTextMimeTypes = new HashSet<String>(Arrays.asList("application/CSV", "application/csv", "text/csv", ContentType.TEXT_PLAIN.getMimeType(), ContentType.TEXT_HTML.getMimeType(), ContentType.TEXT_XML.getMimeType(), ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_ATOM_XML.getMimeType(), ContentType.APPLICATION_XML.getMimeType(), ContentType.APPLICATION_XHTML_XML.getMimeType()));

    public static final String get(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpGet httpGet = HttpClientFacade.createGetRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String post(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpPost httpPost = HttpClientFacade.createPostRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String put(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpPut httpPut = HttpClientFacade.createPutRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String patch(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpPatch httpPatch = HttpClientFacade.createPatchRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPatch);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String delete(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpDelete httpDelete = HttpClientFacade.createDeleteRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String head(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpHead httpHead = HttpClientFacade.createHeadRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpHead);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    public static final String trace(String url, String options) throws IOException {
        HttpClientRequestOptions httpClientRequestOptions = HttpClientFacade.parseOptions(options);
        HttpTrace httpTrace = HttpClientFacade.createTraceRequest(url, httpClientRequestOptions);
        CloseableHttpClient httpClient = HttpClientProxyUtils.getHttpClient(httpClientRequestOptions.isSslTrustAllEnabled());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpTrace);
        return HttpClientFacade.processResponse(response, httpClientRequestOptions.isBinary());
    }

    private static void prepareHeaders(HttpClientRequestOptions httpClientRequestOptions, HttpRequestBase httpRequestBase) {
        for (HttpClientHeader httpClientHeader : httpClientRequestOptions.getHeaders()) {
            httpRequestBase.setHeader(httpClientHeader.getName(), httpClientHeader.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClientResponse processHttpClientResponse(CloseableHttpResponse response, boolean binary) throws IOException {
        try {
            HttpClientResponse httpClientResponse = new HttpClientResponse();
            httpClientResponse.setStatusCode(response.getStatusLine().getStatusCode());
            httpClientResponse.setStatusMessage(response.getStatusLine().getReasonPhrase());
            httpClientResponse.setProtocol(response.getProtocolVersion().getProtocol());
            httpClientResponse.setProtocol(response.getProtocolVersion().getProtocol());
            HttpEntity entity = response.getEntity();
            if (entity != null && entity.getContent() != null) {
                byte[] object = IOUtils.toByteArray((InputStream)entity.getContent());
                String processedContentType = ContentType.getOrDefault((HttpEntity)entity).getMimeType();
                boolean isSupportedTextType = recognizedTextMimeTypes.contains(processedContentType);
                if (!binary && isSupportedTextType) {
                    Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                    String text = new String(object, charset != null ? charset : StandardCharsets.UTF_8);
                    httpClientResponse.setText(text);
                } else {
                    httpClientResponse.setData(object);
                }
            }
            for (Header header : response.getAllHeaders()) {
                httpClientResponse.getHeaders().add(new HttpClientHeader(header.getName(), header.getValue()));
            }
            EntityUtils.consume((HttpEntity)entity);
            HttpClientResponse httpClientResponse2 = httpClientResponse;
            return httpClientResponse2;
        }
        finally {
            response.close();
        }
    }

    private static String processResponse(CloseableHttpResponse response, boolean binary) throws IOException {
        HttpClientResponse httpClientResponse = HttpClientFacade.processHttpClientResponse(response, binary);
        return GsonHelper.toJson((Object)httpClientResponse);
    }

    public static HttpClientRequestOptions parseOptions(String options) {
        return (HttpClientRequestOptions)GsonHelper.fromJson((String)options, HttpClientRequestOptions.class);
    }

    public static RequestConfig prepareConfig(String httpClientRequestOptions) {
        return HttpClientFacade.prepareConfig(HttpClientFacade.parseOptions(httpClientRequestOptions));
    }

    public static RequestConfig prepareConfig(HttpClientRequestOptions httpClientRequestOptions) {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setAuthenticationEnabled(httpClientRequestOptions.isAuthenticationEnabled()).setCircularRedirectsAllowed(httpClientRequestOptions.isCircularRedirectsAllowed()).setContentCompressionEnabled(httpClientRequestOptions.isContentCompressionEnabled()).setExpectContinueEnabled(httpClientRequestOptions.isExpectContinueEnabled()).setRedirectsEnabled(httpClientRequestOptions.isRedirectsEnabled()).setRelativeRedirectsAllowed(httpClientRequestOptions.isRelativeRedirectsAllowed()).setMaxRedirects(httpClientRequestOptions.getMaxRedirects()).setConnectionRequestTimeout(httpClientRequestOptions.getConnectionRequestTimeout()).setConnectTimeout(httpClientRequestOptions.getConnectTimeout()).setSocketTimeout(httpClientRequestOptions.getSocketTimeout()).setCookieSpec(httpClientRequestOptions.getCookieSpec()).setProxyPreferredAuthSchemes(httpClientRequestOptions.getProxyPreferredAuthSchemes()).setTargetPreferredAuthSchemes(httpClientRequestOptions.getTargetPreferredAuthSchemes());
        if (httpClientRequestOptions.getProxyHost() != null && httpClientRequestOptions.getProxyPort() != 0) {
            configBuilder.setProxy(new HttpHost(httpClientRequestOptions.getProxyHost(), httpClientRequestOptions.getProxyPort()));
        }
        RequestConfig config = configBuilder.build();
        return config;
    }

    public static HttpGet createGetRequest(String url, HttpClientRequestOptions httpClientRequestOptions) {
        HttpGet httpGet = new HttpGet(url);
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        httpGet.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpGet);
        return httpGet;
    }

    public static final HttpPost createPostRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getData() != null) {
            return HttpClientFacade.createPostBinaryRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getText() != null) {
            return HttpClientFacade.createPostTextRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getParams() != null) {
            return HttpClientFacade.createPostFormRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getFiles() != null) {
            return HttpClientFacade.createPostFilesRequest(url, httpClientRequestOptions);
        }
        throw new IllegalArgumentException("The element [data] or [text] or [params] or [files] in [options] have to be set for POST requests");
    }

    private static final HttpPost createPostBinaryRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPost);
        HttpEntity entity = EntityBuilder.create().setBinary(httpClientRequestOptions.getData()).setContentType(ContentType.APPLICATION_OCTET_STREAM).build();
        httpPost.setEntity(entity);
        return httpPost;
    }

    private static final HttpPost createPostTextRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getText() == null) {
            throw new IllegalArgumentException("The element [text] in [options] cannot be null for POST requests in [text] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPost);
        String contentTypeString = httpClientRequestOptions.getContentType();
        boolean shouldParseContentType = contentTypeString.contains("charset") || contentTypeString.contains(";");
        ContentType contentType = shouldParseContentType ? ContentType.parse((String)contentTypeString) : ContentType.create((String)contentTypeString);
        EntityBuilder entityBuilder = EntityBuilder.create().setText(httpClientRequestOptions.getText()).setContentType(contentType);
        httpPost.setEntity(entityBuilder.build());
        return httpPost;
    }

    private static final HttpPost createPostFormRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [params] in [options] cannot be null for POST requests in [form] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPost);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (HttpClientParam httpClientParam : httpClientRequestOptions.getParams()) {
            params.add(new BasicNameValuePair(httpClientParam.getName(), httpClientParam.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }

    private static final HttpPost createPostFilesRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [files] in [options] cannot be null for POST requests in [file] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPost);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (String filePath : httpClientRequestOptions.getFiles()) {
            File file = new File(filePath);
            multipartEntityBuilder.addBinaryBody(file.getName(), file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
        }
        HttpEntity entity = multipartEntityBuilder.build();
        httpPost.setEntity(entity);
        return httpPost;
    }

    public static final HttpPut createPutRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getData() != null) {
            return HttpClientFacade.createPutBinaryRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getText() != null) {
            return HttpClientFacade.createPutTextRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getParams() != null) {
            return HttpClientFacade.createPutFormRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getFiles() != null) {
            return HttpClientFacade.createPutFilesRequest(url, httpClientRequestOptions);
        }
        throw new IllegalArgumentException("The element [data] or [text] or [params] or [files] in [options] have to be set for PUT requests");
    }

    private static final HttpPut createPutBinaryRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPut);
        HttpEntity entity = EntityBuilder.create().setBinary(httpClientRequestOptions.getData()).setContentType(ContentType.APPLICATION_OCTET_STREAM).build();
        httpPut.setEntity(entity);
        return httpPut;
    }

    private static final HttpPut createPutTextRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getText() == null) {
            throw new IllegalArgumentException("The element [text] in [options] cannot be null for POST requests in [text] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPut);
        EntityBuilder entityBuilder = EntityBuilder.create().setText(httpClientRequestOptions.getText()).setContentType(ContentType.create((String)httpClientRequestOptions.getContentType()));
        if (httpClientRequestOptions.isCharacterEncodingEnabled()) {
            entityBuilder.setContentEncoding(httpClientRequestOptions.getCharacterEncoding());
        }
        httpPut.setEntity(entityBuilder.build());
        return httpPut;
    }

    private static final HttpPut createPutFormRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [params] in [options] cannot be null for POST requests in [form] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPut);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (HttpClientParam httpClientParam : httpClientRequestOptions.getParams()) {
            params.add(new BasicNameValuePair(httpClientParam.getName(), httpClientParam.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
        httpPut.setEntity((HttpEntity)entity);
        return httpPut;
    }

    private static final HttpPut createPutFilesRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [files] in [options] cannot be null for POST requests in [file] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPut);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (String filePath : httpClientRequestOptions.getFiles()) {
            File file = new File(filePath);
            multipartEntityBuilder.addBinaryBody(file.getName(), file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
        }
        HttpEntity entity = multipartEntityBuilder.build();
        httpPut.setEntity(entity);
        return httpPut;
    }

    public static final HttpPatch createPatchRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getData() != null) {
            return HttpClientFacade.createPatchBinaryRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getText() != null) {
            return HttpClientFacade.createPatchTextRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getParams() != null) {
            return HttpClientFacade.createPatchFormRequest(url, httpClientRequestOptions);
        }
        if (httpClientRequestOptions.getFiles() != null) {
            return HttpClientFacade.createPatchFilesRequest(url, httpClientRequestOptions);
        }
        throw new IllegalArgumentException("The element [data] or [text] or [params] or [files] in [options] have to be set for PATCH requests");
    }

    private static final HttpPatch createPatchBinaryRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPatch);
        HttpEntity entity = EntityBuilder.create().setBinary(httpClientRequestOptions.getData()).setContentType(ContentType.APPLICATION_OCTET_STREAM).build();
        httpPatch.setEntity(entity);
        return httpPatch;
    }

    private static final HttpPatch createPatchTextRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getText() == null) {
            throw new IllegalArgumentException("The element [text] in [options] cannot be null for POST requests in [text] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPatch);
        EntityBuilder entityBuilder = EntityBuilder.create().setText(httpClientRequestOptions.getText()).setContentType(ContentType.create((String)httpClientRequestOptions.getContentType()));
        if (httpClientRequestOptions.isCharacterEncodingEnabled()) {
            entityBuilder.setContentEncoding(httpClientRequestOptions.getCharacterEncoding());
        }
        httpPatch.setEntity(entityBuilder.build());
        return httpPatch;
    }

    private static final HttpPatch createPatchFormRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [params] in [options] cannot be null for POST requests in [form] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPatch);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (HttpClientParam httpClientParam : httpClientRequestOptions.getParams()) {
            params.add(new BasicNameValuePair(httpClientParam.getName(), httpClientParam.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
        httpPatch.setEntity((HttpEntity)entity);
        return httpPatch;
    }

    private static final HttpPatch createPatchFilesRequest(String url, HttpClientRequestOptions httpClientRequestOptions) throws IOException {
        if (httpClientRequestOptions.getParams() == null) {
            throw new IllegalArgumentException("The element [files] in [options] cannot be null for POST requests in [file] mode");
        }
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpPatch);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        for (String filePath : httpClientRequestOptions.getFiles()) {
            File file = new File(filePath);
            multipartEntityBuilder.addBinaryBody(file.getName(), file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
        }
        HttpEntity entity = multipartEntityBuilder.build();
        httpPatch.setEntity(entity);
        return httpPatch;
    }

    public static HttpDelete createDeleteRequest(String url, HttpClientRequestOptions httpClientRequestOptions) {
        HttpDelete httpDelete = new HttpDelete(url);
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        httpDelete.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpDelete);
        return httpDelete;
    }

    public static HttpHead createHeadRequest(String url, HttpClientRequestOptions httpClientRequestOptions) {
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpHead httpHead = new HttpHead(url);
        httpHead.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpHead);
        return httpHead;
    }

    public static HttpTrace createTraceRequest(String url, HttpClientRequestOptions httpClientRequestOptions) {
        RequestConfig config = HttpClientFacade.prepareConfig(httpClientRequestOptions);
        HttpTrace httpTrace = new HttpTrace(url);
        httpTrace.setConfig(config);
        HttpClientFacade.prepareHeaders(httpClientRequestOptions, (HttpRequestBase)httpTrace);
        return httpTrace;
    }
}

