/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.security;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.api.v3.http.HttpSessionFacade;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.eclipse.dirigible.commons.api.context.ThreadContextFacade;
import org.eclipse.dirigible.commons.api.scripting.IScriptingFacade;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFacade
implements IScriptingFacade {
    private static final String DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME = "DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME";
    private static final String DIRIGIBLE_ANONYMOUS_IDENTIFIER = "dirigible-anonymous-identifier";
    private static final String DIRIGIBLE_ANONYMOUS_USER = "dirigible-anonymous-user";
    private static final String DIRIGIBLE_JWT_USER = "dirigible-jwt-user";
    private static final String NO_VALID_REQUEST = "Trying to use HTTP Session Facade without a valid Session (HTTP Request/Response)";
    private static final String INVOCATION_COUNT = "invocation.count";
    private static final String LANGUAGE_HEADER = "accept-language";
    private static final Logger logger = LoggerFactory.getLogger(UserFacade.class);
    private static final String GUEST = "guest";
    private static final String AUTH = "authorization";

    public static final String getName() {
        String userName = null;
        userName = UserFacade.getRemoteUser();
        if (userName == null) {
            userName = UserFacade.getAnonymousUser();
        }
        return userName != null ? userName : GUEST;
    }

    public static final boolean isInRole(String role) {
        if (Configuration.isAnonymousModeEnabled() || Configuration.isAnonymousUserEnabled()) {
            return true;
        }
        try {
            return HttpRequestFacade.isUserInRole((String)role);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public static final void setName(String userName) throws ContextException {
        if (Configuration.isAnonymousModeEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_ANONYMOUS_IDENTIFIER, userName);
            logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the anonymous mode is enabled", userName));
        } else if (Configuration.isAnonymousUserEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_ANONYMOUS_USER, userName);
            logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the anonymous mode is enabled", userName));
        } else if (Configuration.isJwtModeEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_JWT_USER, userName);
            logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the JWT mode is enabled", userName));
        } else {
            throw new SecurityException("Setting the user name programmatically is supported only when the anonymous mode is enabled");
        }
    }

    public static final String getName(HttpServletRequest request) {
        if (request == null) {
            return UserFacade.getName();
        }
        String userName = null;
        try {
            userName = request.getRemoteUser();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (userName != null) {
            return userName;
        }
        return UserFacade.getName();
    }

    public static final String getName(Session session) {
        if (session == null) {
            return UserFacade.getName();
        }
        String userName = null;
        try {
            userName = session.getUserPrincipal().getName();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (userName != null) {
            return userName;
        }
        return UserFacade.getName();
    }

    public static final Integer getTimeout() {
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getMaxInactiveInterval();
        }
        logger.error(NO_VALID_REQUEST);
        return 0;
    }

    public static String getAuthType() {
        if (HttpRequestFacade.isValid()) {
            return HttpRequestFacade.getAuthType();
        }
        logger.error(NO_VALID_REQUEST);
        return null;
    }

    public static String getSecurityToken() {
        if (HttpRequestFacade.isValid()) {
            String token = HttpRequestFacade.getHeader((String)AUTH);
            return token != null && !"".equals(token) ? token.substring(token.indexOf(" ")) : "";
        }
        logger.error(NO_VALID_REQUEST);
        return "";
    }

    public static String getInvocationCount() {
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getAttribute((String)INVOCATION_COUNT);
        }
        logger.error(NO_VALID_REQUEST);
        return null;
    }

    public static String getLanguage() {
        if (HttpRequestFacade.isValid()) {
            String language = HttpRequestFacade.getHeader((String)LANGUAGE_HEADER);
            return language != null && !"".equals(language) ? language.substring(0, language.indexOf(59)) : "";
        }
        logger.error(NO_VALID_REQUEST);
        return null;
    }

    private static String getContextProperty(String property) throws ContextException {
        Object value;
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getAttribute((String)property);
        }
        if (ThreadContextFacade.isValid() && (value = ThreadContextFacade.get((String)property)) != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static void setContextProperty(String property, String value) throws ContextException {
        if (HttpSessionFacade.isValid()) {
            HttpSessionFacade.setAttribute((String)property, (String)value);
        } else if (ThreadContextFacade.isValid()) {
            ThreadContextFacade.set((String)property, (Object)value);
        }
    }

    private static String getRemoteUser() {
        try {
            if (HttpRequestFacade.isValid()) {
                return HttpRequestFacade.getRemoteUser();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    private static String getAnonymousUser() {
        String userName = null;
        if (Configuration.isAnonymousModeEnabled()) {
            try {
                userName = UserFacade.getContextProperty(DIRIGIBLE_ANONYMOUS_IDENTIFIER);
            }
            catch (ContextException e) {
                logger.error(e.getMessage());
            }
        } else if (Configuration.isAnonymousUserEnabled()) {
            try {
                userName = UserFacade.getContextProperty(DIRIGIBLE_ANONYMOUS_USER);
                if (userName == null) {
                    userName = UserFacade.setAnonymousUser();
                }
            }
            catch (ContextException e) {
                logger.error(e.getMessage());
            }
        } else if (Configuration.isJwtModeEnabled()) {
            try {
                userName = UserFacade.getContextProperty(DIRIGIBLE_JWT_USER);
            }
            catch (ContextException e) {
                logger.error(e.getMessage());
            }
        }
        return userName;
    }

    private static String setAnonymousUser() {
        String userName = null;
        String anonymousUserNamePropertyName = Configuration.get((String)DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME);
        if (anonymousUserNamePropertyName != null) {
            userName = Configuration.get((String)anonymousUserNamePropertyName);
            try {
                UserFacade.setName(userName);
            }
            catch (ContextException e) {
                logger.info("Error while setting userName from DIRIGIBLE_ANONYMOUS_USER_PROPERTY_NAME.", (Throwable)e);
            }
        }
        return userName;
    }
}

