/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.api.v3.security;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import org.eclipse.dirigible.api.v3.http.HttpRequestFacade;
import org.eclipse.dirigible.api.v3.http.HttpSessionFacade;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.eclipse.dirigible.commons.api.context.ThreadContextFacade;
import org.eclipse.dirigible.commons.api.scripting.IScriptingFacade;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserFacade
implements IScriptingFacade {
    private static final String DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME = "DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME";
    private static final String DIRIGIBLE_ANONYMOUS_IDENTIFIER = "dirigible-anonymous-identifier";
    private static final String DIRIGIBLE_ANONYMOUS_USER = "dirigible-anonymous-user";
    private static final String DIRIGIBLE_JWT_USER = "dirigible-jwt-user";
    private static final String NO_VALID_REQUEST = "Trying to use HTTP Session Facade without a valid Session (HTTP Request/Response)";
    private static final String INVOCATION_COUNT = "invocation.count";
    private static final String LANGUAGE_HEADER = "accept-language";
    private static final String ANY_LANGUAGE = "*";
    private static final Logger logger = LoggerFactory.getLogger(UserFacade.class);
    private static final String GUEST = "guest";
    private static final String AUTH = "authorization";

    public static final String getName() {
        String userName = null;
        userName = UserFacade.getRemoteUser();
        if (userName == null) {
            userName = UserFacade.getAnonymousUser();
        }
        return userName != null ? userName : GUEST;
    }

    public static final boolean isInRole(String role) {
        if (Configuration.isAnonymousModeEnabled() || Configuration.isAnonymousUserEnabled()) {
            return true;
        }
        try {
            return HttpRequestFacade.isUserInRole((String)role);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getMessage());
            }
            return false;
        }
    }

    public static final void setName(String userName) throws ContextException {
        if (Configuration.isAnonymousModeEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_ANONYMOUS_IDENTIFIER, userName);
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the anonymous mode is enabled", userName));
            }
        } else if (Configuration.isAnonymousUserEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_ANONYMOUS_USER, userName);
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the anonymous mode is enabled", userName));
            }
        } else if (Configuration.isJwtModeEnabled()) {
            UserFacade.setContextProperty(DIRIGIBLE_JWT_USER, userName);
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("User name has been set programmatically {0} to the session as the JWT mode is enabled", userName));
            }
        } else {
            throw new SecurityException("Setting the user name programmatically is supported only when the anonymous mode is enabled");
        }
    }

    public static final String getName(HttpServletRequest request) {
        String userName;
        block4: {
            if (request == null) {
                return UserFacade.getName();
            }
            userName = null;
            try {
                userName = request.getRemoteUser();
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(e.getMessage());
            }
        }
        if (userName != null) {
            return userName;
        }
        return UserFacade.getName();
    }

    public static final String getName(Session session) {
        String userName;
        block4: {
            if (session == null) {
                return UserFacade.getName();
            }
            userName = null;
            try {
                userName = session.getUserPrincipal().getName();
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error(e.getMessage());
            }
        }
        if (userName != null) {
            return userName;
        }
        return UserFacade.getName();
    }

    public static final Integer getTimeout() {
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getMaxInactiveInterval();
        }
        if (logger.isErrorEnabled()) {
            logger.error(NO_VALID_REQUEST);
        }
        return 0;
    }

    public static String getAuthType() {
        if (HttpRequestFacade.isValid()) {
            return HttpRequestFacade.getAuthType();
        }
        if (logger.isErrorEnabled()) {
            logger.error(NO_VALID_REQUEST);
        }
        return null;
    }

    public static String getSecurityToken() {
        if (HttpRequestFacade.isValid()) {
            String token = HttpRequestFacade.getHeader((String)AUTH);
            return token != null && !"".equals(token) ? token.substring(token.indexOf(" ")) : "";
        }
        if (logger.isErrorEnabled()) {
            logger.error(NO_VALID_REQUEST);
        }
        return "";
    }

    public static String getInvocationCount() {
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getAttribute((String)INVOCATION_COUNT);
        }
        if (logger.isErrorEnabled()) {
            logger.error(NO_VALID_REQUEST);
        }
        return null;
    }

    public static String getLanguage() {
        if (HttpRequestFacade.isValid()) {
            List<Locale.LanguageRange> ranges;
            String language = HttpRequestFacade.getHeader((String)LANGUAGE_HEADER);
            if (language == null || language.isEmpty()) {
                language = ANY_LANGUAGE;
            }
            return (ranges = Locale.LanguageRange.parse(language)) == null || ranges.isEmpty() ? "" : ranges.get(0).getRange();
        }
        if (logger.isErrorEnabled()) {
            logger.error(NO_VALID_REQUEST);
        }
        return null;
    }

    private static String getContextProperty(String property) throws ContextException {
        Object value;
        if (HttpSessionFacade.isValid()) {
            return HttpSessionFacade.getAttribute((String)property);
        }
        if (ThreadContextFacade.isValid() && (value = ThreadContextFacade.get((String)property)) != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static void setContextProperty(String property, String value) throws ContextException {
        if (HttpSessionFacade.isValid()) {
            HttpSessionFacade.setAttribute((String)property, (String)value);
        } else if (ThreadContextFacade.isValid()) {
            ThreadContextFacade.set((String)property, (Object)value);
        }
    }

    private static String getRemoteUser() {
        block3: {
            try {
                if (HttpRequestFacade.isValid()) {
                    return HttpRequestFacade.getRemoteUser();
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    private static String getAnonymousUser() {
        String userName;
        block12: {
            userName = null;
            if (Configuration.isAnonymousModeEnabled()) {
                try {
                    userName = UserFacade.getContextProperty(DIRIGIBLE_ANONYMOUS_IDENTIFIER);
                }
                catch (ContextException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error(e.getMessage());
                    }
                    break block12;
                }
            }
            if (Configuration.isAnonymousUserEnabled()) {
                try {
                    userName = UserFacade.getContextProperty(DIRIGIBLE_ANONYMOUS_USER);
                    if (userName == null) {
                        userName = UserFacade.setAnonymousUser();
                    }
                    break block12;
                }
                catch (ContextException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error(e.getMessage());
                    }
                    break block12;
                }
            }
            if (Configuration.isJwtModeEnabled()) {
                try {
                    userName = UserFacade.getContextProperty(DIRIGIBLE_JWT_USER);
                }
                catch (ContextException e) {
                    if (!logger.isErrorEnabled()) break block12;
                    logger.error(e.getMessage());
                }
            }
        }
        return userName;
    }

    private static String setAnonymousUser() {
        String userName;
        block3: {
            userName = null;
            String anonymousUserNamePropertyName = Configuration.get((String)DIRIGIBLE_ANONYMOUS_USER_NAME_PROPERTY_NAME);
            if (anonymousUserNamePropertyName != null) {
                userName = Configuration.get((String)anonymousUserNamePropertyName);
                try {
                    UserFacade.setName(userName);
                }
                catch (ContextException e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info("Error while setting userName from DIRIGIBLE_ANONYMOUS_USER_PROPERTY_NAME.", (Throwable)e);
                }
            }
        }
        return userName;
    }
}

