/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.content;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.dirigible.commons.api.content.IClasspathContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathContentLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathContentLoader.class);
    private static final String ROOT = "/";
    private static Boolean LOADED = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void load() throws IOException {
        Class<ClasspathContentLoader> clazz = ClasspathContentLoader.class;
        synchronized (ClasspathContentLoader.class) {
            if (!LOADED.booleanValue()) {
                ServiceLoader<IClasspathContentHandler> contentHandlers = ServiceLoader.load(IClasspathContentHandler.class);
                for (IClasspathContentHandler contentHandler : contentHandlers) {
                    String message = "Registering Content Handler: " + contentHandler.getClass().getCanonicalName();
                    logger.info(message);
                }
                Enumeration<URL> urls = ClasspathContentLoader.class.getClassLoader().getResources("META-INF");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    URLConnection urlConnection = url.openConnection();
                    if (!(urlConnection instanceof JarURLConnection)) continue;
                    JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
                    JarFile jar = jarUrlConnection.getJarFile();
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            String entry = entries.nextElement().getName();
                            for (IClasspathContentHandler contentHandler : contentHandlers) {
                                contentHandler.accept(ROOT + entry);
                            }
                            logger.trace("resource found: " + entry);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jar == null) continue;
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jar.close();
                    }
                }
                LOADED = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

