/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.helpers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);
    private static final String SEPARATOR = "/";

    public static void saveFile(String workspacePath, byte[] content) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePath);
        Path path = FileSystems.getDefault().getPath(FilenameUtils.normalize((String)workspacePath), new String[0]);
        if (content == null) {
            content = new byte[]{};
        }
        Files.write(path, content, new OpenOption[0]);
    }

    public static byte[] loadFile(String workspacePath) throws FileNotFoundException, IOException {
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        if (path.toFile().exists()) {
            return Files.readAllBytes(path);
        }
        return null;
    }

    public static void moveFile(String workspacePathOld, String workspacePathNew) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePathNew);
        Path pathOld = FileSystems.getDefault().getPath(workspacePathOld, new String[0]);
        Path pathNew = FileSystems.getDefault().getPath(workspacePathNew, new String[0]);
        Files.move(pathOld, pathNew, new CopyOption[0]);
    }

    public static void copyFile(String srcPath, String destPath) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(destPath);
        Path srcFile = FileSystems.getDefault().getPath(srcPath, new String[0]);
        Path destFile = FileSystems.getDefault().getPath(destPath, new String[0]);
        FileUtils.copyFile((File)srcFile.toFile(), (File)destFile.toFile());
    }

    public static void copyFolder(String srcPath, String destPath) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(destPath);
        Path srcDir = FileSystems.getDefault().getPath(srcPath, new String[0]);
        Path destDir = FileSystems.getDefault().getPath(destPath, new String[0]);
        FileUtils.copyDirectory((File)srcDir.toFile(), (File)destDir.toFile(), (boolean)true);
    }

    public static void removeFile(String workspacePath) throws FileNotFoundException, IOException {
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (dir.toFile().exists()) {
                    logger.trace(String.format("Deleting directory: %s", dir));
                    try {
                        Files.delete(dir);
                    }
                    catch (NoSuchFileException e) {
                        logger.trace(String.format("Directory already has been deleted: %s", dir));
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().exists()) {
                    logger.trace(String.format("Deleting file: %s", file));
                    try {
                        Files.delete(file);
                    }
                    catch (NoSuchFileException e) {
                        logger.trace(String.format("File already has been deleted: %s", file));
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                logger.error(String.format("Error in file: %s", file), (Throwable)exc);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean createFolder(String workspacePath) {
        File folder = new File(FilenameUtils.normalize((String)workspacePath));
        if (!folder.exists()) {
            try {
                FileUtils.forceMkdir((File)folder.getCanonicalFile());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean createFile(String workspacePath) throws IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePath);
        File file = new File(workspacePath);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    public static String getExtension(String workspacePath) throws IOException {
        File f = new File(workspacePath);
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getOwner(String workspacePath) throws IOException {
        String convertedPath = FileSystemUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return Files.getOwner(path, new LinkOption[0]).getName();
        }
        return "none";
    }

    public static Date getModifiedAt(String workspacePath) throws IOException {
        String convertedPath = FileSystemUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        return new Date();
    }

    public static void createFoldersIfNecessary(String workspacePath) {
        int lastIndexOf = workspacePath.lastIndexOf(File.separator);
        if (lastIndexOf > 0) {
            String directory = workspacePath.substring(0, lastIndexOf);
            FileSystemUtils.createFolder(directory);
        }
    }

    private static String convertToWorkspacePath(String path) {
        String workspacePath = null;
        workspacePath = path.startsWith(SEPARATOR) ? path.substring(SEPARATOR.length()) : path;
        workspacePath = workspacePath.replace(SEPARATOR, File.separator);
        return workspacePath;
    }

    public static boolean exists(String location) {
        if (location == null || "".equals(location)) {
            return false;
        }
        try {
            Path path = FileSystems.getDefault().getPath(FilenameUtils.normalize((String)location), new String[0]);
            File file = path.toFile();
            return file.exists() && file.getCanonicalFile().getName().equals(file.getName());
        }
        catch (IOException | InvalidPathException e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    public static boolean directoryExists(String location) {
        return FileSystemUtils.exists(location) && FileSystemUtils.isDirectory(location);
    }

    public static boolean fileExists(String location) {
        return FileSystemUtils.exists(location) && !FileSystemUtils.isDirectory(location);
    }

    public static boolean isDirectory(String location) {
        Path path;
        try {
            path = FileSystems.getDefault().getPath(FilenameUtils.normalize((String)location), new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        return path.toFile().isDirectory();
    }
}

