/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.module;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.dirigible.commons.api.module.AbstractDirigibleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirigibleModulesInstallerModule
extends AbstractModule {
    private Logger logger = LoggerFactory.getLogger(DirigibleModulesInstallerModule.class);
    private static Set<String> modules = new HashSet<String>();

    protected void configure() {
        this.logger.debug("Initializing Dirigible Modules...");
        ServiceLoader<AbstractDirigibleModule> dirigibleModules = ServiceLoader.load(AbstractDirigibleModule.class);
        for (AbstractDirigibleModule next : dirigibleModules) {
            this.logger.debug(MessageFormat.format("Installing Dirigible Module [{0}] ...", next.getName()));
            try {
                this.install((Module)next);
            }
            catch (Throwable e) {
                this.logger.error(MessageFormat.format("Failed installing Dirigible Module [{0}].", next.getName()), e);
            }
            this.logger.debug(MessageFormat.format("Done installing Dirigible Module [{0}].", next.getName()));
            modules.add(next.getName());
        }
        this.logger.debug("Done initializing Dirigible Modules.");
    }

    public static Set<String> getModules() {
        return modules;
    }
}

