/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.service;

import com.google.gson.Gson;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.eclipse.dirigible.commons.api.helpers.AppExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionHandler<T extends Throwable>
implements ExceptionMapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExceptionHandler.class);
    @Context
    private HttpServletResponse response;
    private static final Gson GSON = new Gson();

    public Response toResponse(T exception) {
        this.getLogger().error(((Throwable)exception).getMessage(), exception);
        Response.Status status = this.getResponseStatus(exception);
        String message = this.getResponseMessage(exception);
        AppExceptionMessage appException = new AppExceptionMessage(status, message);
        this.sendInternalServerError();
        return Response.status((Response.Status)status).type("application/json").entity((Object)GSON.toJson((Object)appException)).build();
    }

    public abstract Class<? extends AbstractExceptionHandler<T>> getType();

    protected abstract Logger getLogger();

    protected abstract Response.Status getResponseStatus(T var1);

    protected abstract String getResponseMessage(T var1);

    private void sendInternalServerError() {
        try {
            this.response.sendError(500);
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
        }
    }
}

