/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.service;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.commons.api.service.IRestService;
import org.slf4j.Logger;

public abstract class AbstractRestService
implements IRestService {
    public static final String NO_LOGGED_IN_USER = "No logged in user";

    protected abstract Logger getLogger();

    protected void sendErrorNotFound(HttpServletResponse response, String message) {
        try {
            response.sendError(404);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    protected void sendErrorForbidden(HttpServletResponse response, String message) {
        try {
            response.sendError(403);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    protected void sendErrorBadRequest(HttpServletResponse response, String message) {
        try {
            response.sendError(400);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    protected void sendErrorUnathorized(HttpServletResponse response, String message) {
        try {
            response.sendError(401);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    protected void sendErrorInternalServerError(HttpServletResponse response, String message) {
        try {
            response.sendError(500, message);
        }
        catch (IOException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }
}

