/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.dirigible.commons.api.context.ContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadContextFacade {
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextFacade.class);
    private static final ThreadLocal<Map<String, Object>> CONTEXT = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> PROXIES = new ThreadLocal();
    private static final AtomicLong UUID_GENERATOR = new AtomicLong(Long.MIN_VALUE);

    public static final void setUp() throws ContextException {
        if (CONTEXT.get() == null || CONTEXT.get().size() == 0) {
            CONTEXT.set(new HashMap());
        }
        if (PROXIES.get() == null || PROXIES.get().size() == 0) {
            PROXIES.set(new HashMap());
        }
        logger.trace("Scripting context {} has been set up", (Object)Thread.currentThread().hashCode());
    }

    public static final void tearDown() throws ContextException {
        CONTEXT.get().clear();
        CONTEXT.remove();
        PROXIES.get().clear();
        PROXIES.remove();
        logger.trace("Scripting context {} has been torn up", (Object)Thread.currentThread().hashCode());
    }

    public static final Object get(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        return CONTEXT.get().get(key);
    }

    public static final String set(Object value) throws ContextException {
        String uuid = ThreadContextFacade.generateObjectId();
        ThreadContextFacade.set(uuid, value);
        return uuid;
    }

    public static final void set(String key, Object value) throws ContextException {
        ThreadContextFacade.checkContext();
        CONTEXT.get().put(key, value);
        logger.trace("Context object has been added to {} with key {}", (Object)Thread.currentThread().hashCode(), (Object)key);
    }

    public static final void remove(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        CONTEXT.get().remove(key);
        logger.trace("Context object has been removed - key {}", (Object)Thread.currentThread().hashCode(), (Object)key);
    }

    private static void checkContext() throws ContextException {
        if (CONTEXT.get() == null) {
            throw new ContextException("Context has not been initialized");
        }
    }

    public static boolean isValid() {
        return CONTEXT.get() != null;
    }

    public static final Object getProxy(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        return PROXIES.get().get(key);
    }

    public static final String setProxy(Object value) throws ContextException {
        String uuid = ThreadContextFacade.generateObjectId();
        ThreadContextFacade.setProxy(uuid, value);
        return uuid;
    }

    private static String generateObjectId() {
        return Long.toString(UUID_GENERATOR.incrementAndGet(), 36);
    }

    public static final void setProxy(String key, Object value) throws ContextException {
        ThreadContextFacade.checkContext();
        PROXIES.get().put(key, value);
        logger.trace("Proxy object has been added to {} with key {}", (Object)Thread.currentThread().hashCode(), (Object)key);
    }

    public static final void removeProxy(String key) throws ContextException {
        ThreadContextFacade.checkContext();
        PROXIES.get().remove(key);
        logger.trace("Proxy object has been removes - key {}", (Object)Thread.currentThread().hashCode(), (Object)key);
    }
}

