/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.helpers;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("[yyyy/MM/dd][yyyy-MM-dd][dd[ ]MMM[ ]yyyy", Locale.ENGLISH);
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("[HH:mm:ss.SSSSSS][yyyy-MM-dd][HH:mm:ss[.SSS][ Z]]", Locale.ENGLISH);
    private static final DateTimeFormatter datetimeFormatter = DateTimeFormatter.ofPattern("[yyyy/MM/dd HH:mm:ss.SSSSSS][yyyy-MM-dd HH:mm:ss.SSSSSS][yyyy/MM/dd HH:mm:ss[.SSS][ Z]][yyyy-MM-dd HH:mm:ss[.SSS][ Z]][dd[ ]MMM[ ]yyyy:HH:mm:ss.SSS[ Z]]", Locale.ENGLISH);

    public static Date parseDate(String value) {
        value = DateTimeUtils.sanitize(value);
        return Date.valueOf(LocalDate.parse(value, dateFormatter));
    }

    public static Time parseTime(String value) {
        value = DateTimeUtils.sanitize(value);
        value = DateTimeUtils.timezonize(value);
        return Time.valueOf(LocalTime.parse(value, timeFormatter));
    }

    public static Timestamp parseDateTime(String value) {
        value = DateTimeUtils.sanitize(value);
        value = DateTimeUtils.timezonize(value);
        return Timestamp.valueOf(LocalDateTime.parse(value, datetimeFormatter));
    }

    private static String sanitize(String value) {
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        if (value != null && value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value.trim();
    }

    private static String timezonize(String value) {
        if (value != null && ((String)value).indexOf(46) == ((String)value).length() - 8) {
            value = ((String)value).substring(0, ((String)value).indexOf(46) + 4) + " +" + ((String)value).substring(((String)value).indexOf(46) + 4);
        }
        return value;
    }

    private String numberize(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = "0";
        }
        return value;
    }
}

