/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.module;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.dirigible.commons.api.module.AbstractDirigibleModule;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirigibleModulesInstallerModule
extends AbstractModule {
    private Logger logger = LoggerFactory.getLogger(DirigibleModulesInstallerModule.class);
    private static Set<String> modules = new HashSet<String>();

    protected void configure() {
        this.logger.debug("Initializing Dirigible Modules...");
        while (!Configuration.LOADED) {
            this.logger.info("Waiting for Dirigible Configuration to be initialized");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ServiceLoader<AbstractDirigibleModule> dirigibleModules = ServiceLoader.load(AbstractDirigibleModule.class);
        ArrayList<AbstractDirigibleModule> sortedDirigibleModules = new ArrayList<AbstractDirigibleModule>();
        Iterator<AbstractDirigibleModule> iterator = dirigibleModules.iterator();
        while (iterator.hasNext()) {
            sortedDirigibleModules.add(iterator.next());
        }
        Collections.sort(sortedDirigibleModules, new Comparator<AbstractDirigibleModule>(){

            @Override
            public int compare(AbstractDirigibleModule module1, AbstractDirigibleModule module2) {
                int priorityDiff = module1.getPriority() - module2.getPriority();
                if (priorityDiff == 0) {
                    priorityDiff = module1.getName().compareTo(module2.getName());
                }
                return priorityDiff;
            }
        });
        for (AbstractDirigibleModule next : sortedDirigibleModules) {
            this.logger.debug(MessageFormat.format("Installing Dirigible Module [{0}] ...", next.getName()));
            try {
                this.install((Module)next);
            }
            catch (Throwable e) {
                this.logger.error(MessageFormat.format("Failed installing Dirigible Module [{0}].", next.getName()), e);
            }
            this.logger.debug(MessageFormat.format("Done installing Dirigible Module [{0}].", next.getName()));
            modules.add(next.getName());
        }
        this.logger.debug("Done initializing Dirigible Modules.");
    }

    public static Set<String> getModules() {
        return modules;
    }
}

