/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.helpers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.cxf.common.util.StringUtils;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final String FOLDER_TARGET = "target";
    private static final String PREFIX_DOT = ".";
    private static final String PROJECT_JSON = "project.json";
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);
    private static final String SEPARATOR = "/";
    public static final String DOT_GIT = ".git";
    public static final String PROJECT_METADATA_FILE_NAME = "project.json";
    private static String GIT_ROOT_FOLDER;
    private static final String DIRIGIBLE_GIT_ROOT_FOLDER = "DIRIGIBLE_GIT_ROOT_FOLDER";
    private static final String DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER = "DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER";
    private static final String REPOSITORY_GIT_FOLDER;
    private static final String DEFAULT_DIRIGIBLE_GIT_ROOT_FOLDER;

    public static void saveFile(String workspacePath, byte[] content) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePath);
        Path path = FileSystems.getDefault().getPath(FilenameUtils.normalize((String)workspacePath), new String[0]);
        if (content == null) {
            content = new byte[]{};
        }
        Files.write(path, content, new OpenOption[0]);
    }

    public static byte[] loadFile(String workspacePath) throws FileNotFoundException, IOException {
        String normalizedPath = FilenameUtils.normalize((String)workspacePath);
        Path path = FileSystems.getDefault().getPath(normalizedPath, new String[0]);
        if (path.toFile().exists()) {
            return Files.readAllBytes(path);
        }
        return null;
    }

    public static void moveFile(String workspacePathOld, String workspacePathNew) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePathNew);
        Path pathOld = FileSystems.getDefault().getPath(workspacePathOld, new String[0]);
        Path pathNew = FileSystems.getDefault().getPath(workspacePathNew, new String[0]);
        Files.move(pathOld, pathNew, new CopyOption[0]);
    }

    public static void copyFile(String srcPath, String destPath) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(destPath);
        FileSystem fileSystem = FileSystems.getDefault();
        Path srcFile = fileSystem.getPath(srcPath, new String[0]);
        Path destFile = fileSystem.getPath(destPath, new String[0]);
        if (FileSystemUtils.fileExists(destFile.toString())) {
            Object fileName = destFile.getFileName().toString();
            String destFilePath = destPath.substring(0, destPath.lastIndexOf((String)fileName));
            String fileTitle = "";
            String fileExt = "";
            if (((String)fileName).indexOf(46) != -1) {
                fileTitle = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(PREFIX_DOT));
                fileExt = ((String)fileName).substring(((String)fileName).lastIndexOf(PREFIX_DOT));
            } else {
                fileTitle = fileName;
            }
            int inc = 1;
            fileName = fileTitle + " (copy " + inc + ")" + fileExt;
            while (FileSystemUtils.fileExists(destFilePath + (String)fileName)) {
                fileName = fileTitle + " (copy " + ++inc + ")" + fileExt;
            }
            destFile = fileSystem.getPath(destFilePath + (String)fileName, new String[0]);
        }
        FileUtils.copyFile((File)srcFile.toFile(), (File)destFile.toFile());
    }

    public static void copyFolder(String srcPath, String destPath) throws FileNotFoundException, IOException {
        FileSystemUtils.createFoldersIfNecessary(destPath);
        FileSystem fileSystem = FileSystems.getDefault();
        Path srcDir = fileSystem.getPath(srcPath, new String[0]);
        Path destDir = fileSystem.getPath(destPath, new String[0]);
        FileUtils.copyDirectory((File)srcDir.toFile(), (File)destDir.toFile(), (boolean)true);
    }

    public static void removeFile(String workspacePath) throws FileNotFoundException, IOException {
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(path, opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (dir.toFile().exists()) {
                    logger.trace(String.format("Deleting directory: %s", dir));
                    try {
                        Files.delete(dir);
                    }
                    catch (NoSuchFileException e) {
                        logger.trace(String.format("Directory already has been deleted: %s", dir));
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().exists()) {
                    logger.trace(String.format("Deleting file: %s", file));
                    try {
                        Files.delete(file);
                    }
                    catch (NoSuchFileException e) {
                        logger.trace(String.format("File already has been deleted: %s", file));
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                logger.error(String.format("Error in file: %s", file), (Throwable)exc);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean createFolder(String workspacePath) {
        File folder = new File(FilenameUtils.normalize((String)workspacePath));
        if (!folder.exists()) {
            try {
                FileUtils.forceMkdir((File)folder.getCanonicalFile());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean createFile(String workspacePath) throws IOException {
        FileSystemUtils.createFoldersIfNecessary(workspacePath);
        File file = new File(workspacePath);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    public static String getExtension(String workspacePath) throws IOException {
        File f = new File(workspacePath);
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getOwner(String workspacePath) throws IOException {
        String convertedPath = FileSystemUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return Files.getOwner(path, new LinkOption[0]).getName();
        }
        return "none";
    }

    public static Date getModifiedAt(String workspacePath) throws IOException {
        String convertedPath = FileSystemUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        return new Date();
    }

    public static void createFoldersIfNecessary(String workspacePath) {
        String directory;
        String normalizedPath = FilenameUtils.normalize((String)workspacePath);
        int lastIndexOf = normalizedPath.lastIndexOf(File.separator);
        if (lastIndexOf > 0 && !FileSystemUtils.directoryExists(directory = normalizedPath.substring(0, lastIndexOf))) {
            FileSystemUtils.createFolder(directory);
        }
    }

    private static String convertToWorkspacePath(String path) {
        String normalizedPath = FilenameUtils.normalize((String)path);
        String workspacePath = null;
        workspacePath = normalizedPath.startsWith(SEPARATOR) ? normalizedPath.substring(SEPARATOR.length()) : normalizedPath;
        workspacePath = workspacePath.replace(SEPARATOR, File.separator);
        return workspacePath;
    }

    public static boolean exists(String location) {
        if (location == null || "".equals(location)) {
            return false;
        }
        try {
            String normalizedPath = FilenameUtils.normalize((String)location);
            Path path = FileSystems.getDefault().getPath(normalizedPath, new String[0]);
            File file = path.toFile();
            return file.exists() && file.getCanonicalFile().getName().equals(file.getName());
        }
        catch (IOException | InvalidPathException e) {
            logger.warn(e.getMessage());
            return false;
        }
    }

    public static boolean directoryExists(String location) {
        return FileSystemUtils.exists(location) && FileSystemUtils.isDirectory(location);
    }

    public static boolean fileExists(String location) {
        return FileSystemUtils.exists(location) && !FileSystemUtils.isDirectory(location);
    }

    public static boolean isDirectory(String location) {
        Path path;
        try {
            String normalizedPath = FilenameUtils.normalize((String)location);
            path = FileSystems.getDefault().getPath(normalizedPath, new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        return path.toFile().isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] listFiles(File directory) throws IOException {
        Path link = Paths.get(directory.getAbsolutePath(), new String[0]);
        try (Stream<Path> filesStream = Files.list(link);){
            Path[] paths = (Path[])filesStream.toArray(Path[]::new);
            File[] files = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                files[i] = paths[i].toFile();
            }
            File[] fileArray = files;
            return fileArray;
        }
    }

    public static File forceCreateDirectory(String firstSegment, String ... segments) throws IOException {
        Path dir = Paths.get(firstSegment, segments);
        if (dir.toFile().exists()) {
            return dir.toFile();
        }
        return Files.createDirectories(dir, new FileAttribute[0]).toFile();
    }

    public static void deleteDirectory(String firstSegment, String ... segments) throws IOException {
        Path dir = Paths.get(firstSegment, segments);
        File file = new File(String.valueOf(dir));
        FileUtils.deleteDirectory((File)file);
    }

    public static File getDirectory(String firstSegment, String ... segments) {
        Path dir = Paths.get(firstSegment, segments);
        if (dir.toFile().exists()) {
            return dir.toFile();
        }
        return null;
    }

    public static String generateGitRepositoryName(String repositoryURI) {
        int separatorLastIndexOf = repositoryURI.lastIndexOf(SEPARATOR) + 1;
        int gitLastIndexOf = repositoryURI.lastIndexOf(DOT_GIT);
        String repositoryName = repositoryURI;
        if (separatorLastIndexOf >= 0 && gitLastIndexOf > 0) {
            repositoryName = repositoryURI.substring(separatorLastIndexOf, gitLastIndexOf);
        } else if (separatorLastIndexOf >= 0) {
            repositoryName = repositoryURI.substring(separatorLastIndexOf);
        }
        return repositoryName;
    }

    public static File getGitDirectory(String user, String workspace) {
        return FileSystemUtils.getDirectory(GIT_ROOT_FOLDER, user, workspace);
    }

    public static List<String> getGitRepositories(String user, String workspace) {
        File gitRoot = FileSystemUtils.getGitDirectory(user, workspace);
        if (gitRoot == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(gitRoot.listFiles()).stream().filter(e -> !e.isFile()).map(e -> e.getName()).collect(Collectors.toList());
    }

    public static File getGitDirectory(String user, String workspace, String repositoryURI) {
        String repositoryName = FileSystemUtils.generateGitRepositoryName(repositoryURI);
        return FileSystemUtils.getDirectory(GIT_ROOT_FOLDER, user, workspace, repositoryName);
    }

    public static File getGitDirectoryByRepositoryName(String user, String workspace, String repositoryName) {
        File directGitDirectory = FileSystemUtils.getDirectory(GIT_ROOT_FOLDER, user, workspace, repositoryName);
        return directGitDirectory;
    }

    public static File getGitDeepDirectoryByRepositoryName(String user, String workspace, String repositoryName) {
        File[] files;
        File workspaceGitDirectory = FileSystemUtils.getDirectory(GIT_ROOT_FOLDER, user, workspace);
        if (workspaceGitDirectory == null) {
            return null;
        }
        for (File child : files = workspaceGitDirectory.listFiles()) {
            File foundMaybe;
            if (!child.isDirectory() || (foundMaybe = FileSystemUtils.checkSubfolder(child, repositoryName)) == null) continue;
            return foundMaybe;
        }
        return null;
    }

    private static File checkSubfolder(File rootFolder, String repositoryName) {
        if (rootFolder.getName().startsWith(PREFIX_DOT) || rootFolder.getName().equals(FOLDER_TARGET)) {
            return null;
        }
        if (rootFolder.getName().equals(repositoryName)) {
            File[] rootFiles;
            for (File projectMaybe : rootFiles = rootFolder.listFiles()) {
                if (projectMaybe.isFile()) {
                    if (!projectMaybe.getName().equals("project.json")) continue;
                    return projectMaybe.getParentFile();
                }
                File foundMaybe = FileSystemUtils.checkSubfolder(projectMaybe, repositoryName);
                if (foundMaybe == null) continue;
                return foundMaybe;
            }
        } else {
            File[] rootFiles;
            for (File projectMaybe : rootFiles = rootFolder.listFiles()) {
                File foundMaybe;
                if (!projectMaybe.isDirectory() || (foundMaybe = FileSystemUtils.checkSubfolder(projectMaybe, repositoryName)) == null) continue;
                return foundMaybe;
            }
        }
        return null;
    }

    public static List<String> getGitRepositoryProjects(String user, String workspace, String repositoryName) {
        List<File> projects = FileSystemUtils.getGitRepositoryProjectsFiles(user, workspace, repositoryName);
        return projects.stream().map(e -> e.getName()).collect(Collectors.toList());
    }

    public static List<File> getGitRepositoryProjectsFiles(String user, String workspace, String repositoryName) {
        File gitRepository = FileSystemUtils.getGitDirectoryByRepositoryName(user, workspace, repositoryName);
        return FileSystemUtils.getGitRepositoryProjects(gitRepository);
    }

    public static List<File> getGitRepositoryProjects(File gitRepository) {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        ProjectsFinder projectsFinder = new ProjectsFinder();
        try {
            Files.walkFileTree(Paths.get(gitRepository.getAbsolutePath(), new String[0]), opts, Integer.MAX_VALUE, projectsFinder);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<File> gitProjects = projectsFinder.getProjects();
        return gitProjects;
    }

    public static final List<String> find(String root, String pattern) throws IOException {
        Path startingDir = Paths.get(root, new String[0]);
        Finder finder = new Finder(pattern);
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(startingDir, opts, Integer.MAX_VALUE, finder);
        finder.done();
        return finder.getFiles();
    }

    static {
        REPOSITORY_GIT_FOLDER = "dirigible" + File.separator + "repository" + File.separator + DOT_GIT;
        DEFAULT_DIRIGIBLE_GIT_ROOT_FOLDER = FOLDER_TARGET + File.separator + REPOSITORY_GIT_FOLDER;
        GIT_ROOT_FOLDER = !StringUtils.isEmpty((String)Configuration.get((String)DIRIGIBLE_GIT_ROOT_FOLDER)) ? Configuration.get((String)DIRIGIBLE_GIT_ROOT_FOLDER) : (!StringUtils.isEmpty((String)Configuration.get((String)DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER)) ? Configuration.get((String)DIRIGIBLE_REPOSITORY_LOCAL_ROOT_FOLDER) + File.separator + REPOSITORY_GIT_FOLDER : DEFAULT_DIRIGIBLE_GIT_ROOT_FOLDER);
    }

    private static class ProjectsFinder
    extends SimpleFileVisitor<Path> {
        private List<File> projects = new ArrayList<File>();

        private ProjectsFinder() {
        }

        public List<File> getProjects() {
            return this.projects;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            File file = path.toFile();
            if (file.exists() && file.isFile() && file.getName().equals("project.json")) {
                this.projects.add(file.getParentFile());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            logger.error(exc.getMessage(), (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class Finder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private List<String> files = new ArrayList<String>();

        Finder(String pattern) {
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        }

        void find(Path file) {
            Path name = file.getFileName();
            if (name != null && this.matcher.matches(name)) {
                this.files.add(file.toString());
            }
        }

        void done() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.find(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            this.find(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            logger.error(exc.getMessage(), (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        public List<String> getFiles() {
            return this.files;
        }
    }
}

