/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.content;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.commons.api.content.IClasspathContentHandler;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;

public abstract class AbstractClasspathContentHandler
implements IClasspathContentHandler {
    private static final String DIRIGIBLE_SYNCHRONIZER_EXCLUDE_PATHS = "DIRIGIBLE_SYNCHRONIZER_EXCLUDE_PATHS";
    private static final String EXCLUDE_SEPARATOR = ",";
    private final Set<String> resources = Collections.synchronizedSet(new HashSet());
    private static Set<String> EXCLUDES = Collections.synchronizedSet(new HashSet());

    @Override
    public void accept(String path) {
        if (EXCLUDES.size() > 0) {
            for (String exclude : EXCLUDES) {
                if (!path.startsWith(exclude)) continue;
                this.getLogger().info("Excluded: " + path);
                return;
            }
        }
        if (this.isValid(path)) {
            this.resources.add(path);
            this.getLogger().info("Added: " + path);
        }
    }

    @Override
    public Set<String> getPaths() {
        return this.resources;
    }

    protected abstract boolean isValid(String var1);

    protected abstract Logger getLogger();

    static {
        String pathsToExclude = Configuration.get((String)DIRIGIBLE_SYNCHRONIZER_EXCLUDE_PATHS);
        if (pathsToExclude != null && !"".equals(pathsToExclude.trim())) {
            String[] paths;
            for (String path : paths = pathsToExclude.split(EXCLUDE_SEPARATOR)) {
                EXCLUDES.add(path);
            }
        }
    }
}

