/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.commons.api.module;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.dirigible.commons.api.module.IDirigibleModule;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirigibleModulesInstallerModule {
    private static Logger logger = LoggerFactory.getLogger(DirigibleModulesInstallerModule.class);
    private static Set<String> modules = new HashSet<String>();

    public static synchronized void configure() {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing Dirigible Modules...");
        }
        while (!Configuration.LOADED) {
            if (logger.isInfoEnabled()) {
                logger.info("Waiting for Dirigible Configuration to be initialized");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ServiceLoader<IDirigibleModule> dirigibleModules = ServiceLoader.load(IDirigibleModule.class);
        ArrayList<IDirigibleModule> sortedDirigibleModules = new ArrayList<IDirigibleModule>();
        Iterator<IDirigibleModule> iterator = dirigibleModules.iterator();
        while (iterator.hasNext()) {
            sortedDirigibleModules.add(iterator.next());
        }
        Collections.sort(sortedDirigibleModules, new Comparator<IDirigibleModule>(){

            @Override
            public int compare(IDirigibleModule module1, IDirigibleModule module2) {
                int priorityDiff = module1.getPriority() - module2.getPriority();
                if (priorityDiff == 0) {
                    priorityDiff = module1.getName().compareTo(module2.getName());
                }
                return priorityDiff;
            }
        });
        for (IDirigibleModule next : sortedDirigibleModules) {
            block12: {
                if (logger.isDebugEnabled()) {
                    logger.debug(MessageFormat.format("Installing Dirigible Module [{0}] ...", next.getName()));
                }
                try {
                    next.configure();
                }
                catch (Throwable e) {
                    if (!logger.isErrorEnabled()) break block12;
                    logger.error(MessageFormat.format("Failed installing Dirigible Module [{0}].", next.getName()), e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(MessageFormat.format("Done installing Dirigible Module [{0}].", next.getName()));
            }
            modules.add(next.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Done initializing Dirigible Modules.");
        }
    }

    public static Set<String> getModules() {
        return modules.stream().collect(Collectors.toSet());
    }
}

